/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.system.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.system.ui.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entityType", "configuration"})
public class KnowledgePanel {
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="Entity Type.")
    @NotNull
    private EntityType entityType = EntityType.fromValue("KnowledgePanel");
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Configuration for the Knowledge Panel.")
    @Valid
    private Configuration configuration;

    @JsonProperty(value="entityType")
    public EntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public KnowledgePanel withEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="configuration")
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="configuration")
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public KnowledgePanel withConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KnowledgePanel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("configuration");
        sb.append('=');
        sb.append(this.configuration == null ? "<null>" : this.configuration);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.configuration == null ? 0 : this.configuration.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KnowledgePanel)) {
            return false;
        }
        KnowledgePanel rhs = (KnowledgePanel)other;
        return (this.configuration == rhs.configuration || this.configuration != null && this.configuration.equals(rhs.configuration)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals((Object)rhs.entityType));
    }

    public static enum EntityType {
        KNOWLEDGE_PANEL("KnowledgePanel");

        private final String value;
        private static final Map<String, EntityType> CONSTANTS;

        private EntityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EntityType fromValue(String value) {
            EntityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, EntityType>();
            for (EntityType c : EntityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

