/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.system.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.system.ui.Layout;
import org.openmetadata.schema.system.ui.PageType;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"entityType", "pageType", "layout", "persona", "domain", "knowledgePanels"})
public class Page {
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="Entity Type.")
    @NotNull
    private EntityType entityType = EntityType.fromValue("Page");
    @JsonProperty(value="pageType")
    @JsonPropertyDescription(value="This schema defines the type used for describing different types of pages.")
    @NotNull
    private PageType pageType;
    @JsonProperty(value="layout")
    @JsonPropertyDescription(value="Configuration for the Knowledge Panel.")
    @Valid
    @NotNull
    private Layout layout;
    @JsonProperty(value="persona")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference persona;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;
    @JsonProperty(value="knowledgePanels")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    @NotNull
    private List<EntityReference> knowledgePanels = null;

    @JsonProperty(value="entityType")
    public EntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public Page withEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="pageType")
    public PageType getPageType() {
        return this.pageType;
    }

    @JsonProperty(value="pageType")
    public void setPageType(PageType pageType) {
        this.pageType = pageType;
    }

    public Page withPageType(PageType pageType) {
        this.pageType = pageType;
        return this;
    }

    @JsonProperty(value="layout")
    public Layout getLayout() {
        return this.layout;
    }

    @JsonProperty(value="layout")
    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Page withLayout(Layout layout) {
        this.layout = layout;
        return this;
    }

    @JsonProperty(value="persona")
    public EntityReference getPersona() {
        return this.persona;
    }

    @JsonProperty(value="persona")
    public void setPersona(EntityReference persona) {
        this.persona = persona;
    }

    public Page withPersona(EntityReference persona) {
        this.persona = persona;
        return this;
    }

    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public Page withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="knowledgePanels")
    public List<EntityReference> getKnowledgePanels() {
        return this.knowledgePanels;
    }

    @JsonProperty(value="knowledgePanels")
    public void setKnowledgePanels(List<EntityReference> knowledgePanels) {
        this.knowledgePanels = knowledgePanels;
    }

    public Page withKnowledgePanels(List<EntityReference> knowledgePanels) {
        this.knowledgePanels = knowledgePanels;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Page.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("pageType");
        sb.append('=');
        sb.append(this.pageType == null ? "<null>" : this.pageType);
        sb.append(',');
        sb.append("layout");
        sb.append('=');
        sb.append(this.layout == null ? "<null>" : this.layout);
        sb.append(',');
        sb.append("persona");
        sb.append('=');
        sb.append(this.persona == null ? "<null>" : this.persona);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("knowledgePanels");
        sb.append('=');
        sb.append(this.knowledgePanels == null ? "<null>" : this.knowledgePanels);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.layout == null ? 0 : this.layout.hashCode());
        result = result * 31 + (this.pageType == null ? 0 : this.pageType.hashCode());
        result = result * 31 + (this.persona == null ? 0 : this.persona.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.knowledgePanels == null ? 0 : this.knowledgePanels.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Page)) {
            return false;
        }
        Page rhs = (Page)other;
        return (this.layout == rhs.layout || this.layout != null && this.layout.equals(rhs.layout)) && (this.pageType == rhs.pageType || this.pageType != null && this.pageType.equals((Object)rhs.pageType)) && (this.persona == rhs.persona || this.persona != null && this.persona.equals(rhs.persona)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals((Object)rhs.entityType)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.knowledgePanels == rhs.knowledgePanels || this.knowledgePanels != null && this.knowledgePanels.equals(rhs.knowledgePanels));
    }

    public static enum EntityType {
        PAGE("Page");

        private final String value;
        private static final Map<String, EntityType> CONSTANTS;

        private EntityType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EntityType fromValue(String value) {
            EntityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, EntityType>();
            for (EntityType c : EntityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

