/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.system.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum PageType {
    LANDING_PAGE("LandingPage"),
    TABLE_LANDING_PAGE("TableLandingPage"),
    STORED_PROCEDURE_LANDING_PAGE("StoredProcedureLandingPage"),
    DATABASE_LANDING_PAGE("DatabaseLandingPage"),
    DATABASE_SCHEMA_LANDING_PAGE("DatabaseSchemaLandingPage"),
    TOPIC_LANDING_PAGE("TopicLandingPage"),
    PIPELINE_LANDING_PAGE("PipelineLandingPage"),
    DASHBOARD_LANDING_PAGE("DashboardLandingPage"),
    DASHBOARD_DATA_MODEL_LANDING_PAGE("DashboardDataModelLandingPage"),
    CONTAINER_LANDING_PAGE("ContainerLandingPage"),
    SEARCH_INDEX_LANDING_PAGE("SearchIndexLandingPage"),
    GLOSSARY_LANDING_PAGE("GlossaryLandingPage"),
    GLOSSARY_TERM_LANDING_PAGE("GlossaryTermLandingPage"),
    DOMAIN_LANDING_PAGE("DomainLandingPage");

    private final String value;
    private static final Map<String, PageType> CONSTANTS;

    private PageType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static PageType fromValue(String value) {
        PageType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, PageType>();
        for (PageType c : PageType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

