/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.tests.Datum;
import org.openmetadata.schema.tests.type.DataQualityReportMetadata;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"metadata", "data"})
public class DataQualityReport {
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Schema to capture data quality reports and aggregation data.")
    @Valid
    @NotNull
    private DataQualityReportMetadata metadata;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Data for the data quality report.")
    @Valid
    @NotNull
    private List<Datum> data = new ArrayList<Datum>();

    @JsonProperty(value="metadata")
    public DataQualityReportMetadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(DataQualityReportMetadata metadata) {
        this.metadata = metadata;
    }

    public DataQualityReport withMetadata(DataQualityReportMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonProperty(value="data")
    public List<Datum> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(List<Datum> data) {
        this.data = data;
    }

    public DataQualityReport withData(List<Datum> data) {
        this.data = data;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataQualityReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataQualityReport)) {
            return false;
        }
        DataQualityReport rhs = (DataQualityReport)other;
        return (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata));
    }
}

