/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.openmetadata.schema.tests.type.TestCaseStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"testCaseName", "status", "timestamp"})
public class ResultSummary {
    @JsonProperty(value="testCaseName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String testCaseName;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="Status of Test Case run.")
    private TestCaseStatus status;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="testCaseName")
    public String getTestCaseName() {
        return this.testCaseName;
    }

    @JsonProperty(value="testCaseName")
    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public ResultSummary withTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
        return this;
    }

    @JsonProperty(value="status")
    public TestCaseStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(TestCaseStatus status) {
        this.status = status;
    }

    public ResultSummary withStatus(TestCaseStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public ResultSummary withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ResultSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResultSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("testCaseName");
        sb.append('=');
        sb.append(this.testCaseName == null ? "<null>" : this.testCaseName);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.testCaseName == null ? 0 : this.testCaseName.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResultSummary)) {
            return false;
        }
        ResultSummary rhs = (ResultSummary)other;
        return (this.testCaseName == rhs.testCaseName || this.testCaseName != null && this.testCaseName.equals(rhs.testCaseName)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

