/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestCaseParameter;
import org.openmetadata.schema.tests.TestPlatform;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ColumnDataType;
import org.openmetadata.schema.type.DataQualityDimensions;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.TestDefinitionEntityType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "displayName", "fullyQualifiedName", "description", "entityType", "testPlatforms", "supportedDataTypes", "parameterDefinition", "dataQualityDimension", "owners", "provider", "version", "updatedAt", "updatedBy", "href", "changeDescription", "deleted", "supportsRowLevelPassedFailed", "domain", "supportsDynamicAssertion"})
public class TestDefinition
implements EntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies a test definition and test case.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this test case.")
    private String displayName;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    @NotNull
    private String description;
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="This enum defines the type for which this test definition applies to.")
    private TestDefinitionEntityType entityType;
    @JsonProperty(value="testPlatforms")
    @Valid
    @NotNull
    private List<TestPlatform> testPlatforms = new ArrayList<TestPlatform>();
    @JsonProperty(value="supportedDataTypes")
    @Valid
    private List<ColumnDataType> supportedDataTypes = new ArrayList<ColumnDataType>();
    @JsonProperty(value="parameterDefinition")
    @Valid
    private List<TestCaseParameter> parameterDefinition = new ArrayList<TestCaseParameter>();
    @JsonProperty(value="dataQualityDimension")
    @JsonPropertyDescription(value="This enum defines the dimension a test case belongs to.")
    private DataQualityDimensions dataQualityDimension;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="provider")
    @JsonPropertyDescription(value="Type of provider of an entity. Some entities are provided by the `system`. Some are entities created and provided by the `user`. Typically `system` provide entities can't be deleted and can only be disabled.")
    private ProviderType provider = ProviderType.fromValue("user");
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="supportsRowLevelPassedFailed")
    @JsonPropertyDescription(value="When `true` indicates the test case supports row level passed/failed.")
    private Boolean supportsRowLevelPassedFailed = false;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;
    @JsonProperty(value="supportsDynamicAssertion")
    @JsonPropertyDescription(value="When `true` indicates the test case supports dynamic assertions.")
    private Boolean supportsDynamicAssertion = false;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public TestDefinition withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public TestDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public TestDefinition withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public TestDefinition withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TestDefinition withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="entityType")
    public TestDefinitionEntityType getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(TestDefinitionEntityType entityType) {
        this.entityType = entityType;
    }

    public TestDefinition withEntityType(TestDefinitionEntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="testPlatforms")
    public List<TestPlatform> getTestPlatforms() {
        return this.testPlatforms;
    }

    @JsonProperty(value="testPlatforms")
    public void setTestPlatforms(List<TestPlatform> testPlatforms) {
        this.testPlatforms = testPlatforms;
    }

    public TestDefinition withTestPlatforms(List<TestPlatform> testPlatforms) {
        this.testPlatforms = testPlatforms;
        return this;
    }

    @JsonProperty(value="supportedDataTypes")
    public List<ColumnDataType> getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @JsonProperty(value="supportedDataTypes")
    public void setSupportedDataTypes(List<ColumnDataType> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
    }

    public TestDefinition withSupportedDataTypes(List<ColumnDataType> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
        return this;
    }

    @JsonProperty(value="parameterDefinition")
    public List<TestCaseParameter> getParameterDefinition() {
        return this.parameterDefinition;
    }

    @JsonProperty(value="parameterDefinition")
    public void setParameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public TestDefinition withParameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
        return this;
    }

    @JsonProperty(value="dataQualityDimension")
    public DataQualityDimensions getDataQualityDimension() {
        return this.dataQualityDimension;
    }

    @JsonProperty(value="dataQualityDimension")
    public void setDataQualityDimension(DataQualityDimensions dataQualityDimension) {
        this.dataQualityDimension = dataQualityDimension;
    }

    public TestDefinition withDataQualityDimension(DataQualityDimensions dataQualityDimension) {
        this.dataQualityDimension = dataQualityDimension;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public TestDefinition withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="provider")
    public ProviderType getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    public void setProvider(ProviderType provider) {
        this.provider = provider;
    }

    public TestDefinition withProvider(ProviderType provider) {
        this.provider = provider;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public TestDefinition withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TestDefinition withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public TestDefinition withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public TestDefinition withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public TestDefinition withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public TestDefinition withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty(value="supportsRowLevelPassedFailed")
    public Boolean getSupportsRowLevelPassedFailed() {
        return this.supportsRowLevelPassedFailed;
    }

    @JsonProperty(value="supportsRowLevelPassedFailed")
    public void setSupportsRowLevelPassedFailed(Boolean supportsRowLevelPassedFailed) {
        this.supportsRowLevelPassedFailed = supportsRowLevelPassedFailed;
    }

    public TestDefinition withSupportsRowLevelPassedFailed(Boolean supportsRowLevelPassedFailed) {
        this.supportsRowLevelPassedFailed = supportsRowLevelPassedFailed;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public TestDefinition withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="supportsDynamicAssertion")
    public Boolean getSupportsDynamicAssertion() {
        return this.supportsDynamicAssertion;
    }

    @JsonProperty(value="supportsDynamicAssertion")
    public void setSupportsDynamicAssertion(Boolean supportsDynamicAssertion) {
        this.supportsDynamicAssertion = supportsDynamicAssertion;
    }

    public TestDefinition withSupportsDynamicAssertion(Boolean supportsDynamicAssertion) {
        this.supportsDynamicAssertion = supportsDynamicAssertion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestDefinition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("testPlatforms");
        sb.append('=');
        sb.append(this.testPlatforms == null ? "<null>" : this.testPlatforms);
        sb.append(',');
        sb.append("supportedDataTypes");
        sb.append('=');
        sb.append(this.supportedDataTypes == null ? "<null>" : this.supportedDataTypes);
        sb.append(',');
        sb.append("parameterDefinition");
        sb.append('=');
        sb.append(this.parameterDefinition == null ? "<null>" : this.parameterDefinition);
        sb.append(',');
        sb.append("dataQualityDimension");
        sb.append('=');
        sb.append(this.dataQualityDimension == null ? "<null>" : this.dataQualityDimension);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("provider");
        sb.append('=');
        sb.append(this.provider == null ? "<null>" : this.provider);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("supportsRowLevelPassedFailed");
        sb.append('=');
        sb.append(this.supportsRowLevelPassedFailed == null ? "<null>" : this.supportsRowLevelPassedFailed);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("supportsDynamicAssertion");
        sb.append('=');
        sb.append(this.supportsDynamicAssertion == null ? "<null>" : this.supportsDynamicAssertion);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.supportsDynamicAssertion == null ? 0 : this.supportsDynamicAssertion.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.parameterDefinition == null ? 0 : this.parameterDefinition.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.dataQualityDimension == null ? 0 : this.dataQualityDimension.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.testPlatforms == null ? 0 : this.testPlatforms.hashCode());
        result = result * 31 + (this.supportsRowLevelPassedFailed == null ? 0 : this.supportsRowLevelPassedFailed.hashCode());
        result = result * 31 + (this.provider == null ? 0 : this.provider.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.supportedDataTypes == null ? 0 : this.supportedDataTypes.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestDefinition)) {
            return false;
        }
        TestDefinition rhs = (TestDefinition)other;
        return (this.supportsDynamicAssertion == rhs.supportsDynamicAssertion || this.supportsDynamicAssertion != null && this.supportsDynamicAssertion.equals(rhs.supportsDynamicAssertion)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals((Object)rhs.entityType)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.parameterDefinition == rhs.parameterDefinition || this.parameterDefinition != null && this.parameterDefinition.equals(rhs.parameterDefinition)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.dataQualityDimension == rhs.dataQualityDimension || this.dataQualityDimension != null && this.dataQualityDimension.equals((Object)rhs.dataQualityDimension)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.testPlatforms == rhs.testPlatforms || this.testPlatforms != null && this.testPlatforms.equals(rhs.testPlatforms)) && (this.supportsRowLevelPassedFailed == rhs.supportsRowLevelPassedFailed || this.supportsRowLevelPassedFailed != null && this.supportsRowLevelPassedFailed.equals(rhs.supportsRowLevelPassedFailed)) && (this.provider == rhs.provider || this.provider != null && this.provider.equals((Object)rhs.provider)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.supportedDataTypes == rhs.supportedDataTypes || this.supportedDataTypes != null && this.supportedDataTypes.equals(rhs.supportedDataTypes)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }
}

