/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.EnumInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.schema.tests.ResultSummary;
import org.openmetadata.schema.tests.TestSuiteConnection;
import org.openmetadata.schema.tests.type.TestSummary;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "name", "displayName", "fullyQualifiedName", "description", "tests", "connection", "testConnectionResult", "pipelines", "serviceType", "owners", "version", "updatedAt", "updatedBy", "href", "changeDescription", "deleted", "executable", "executableEntityReference", "summary", "testCaseResultSummary", "domain", "tags"})
public class TestSuite
implements ServiceEntityInterface {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID id;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of a test suite entity. For executable testSuite, this should match the entity FQN in the platform.")
    @Size(min=1, max=256)
    @NotNull
    private @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this test suite.")
    private String displayName;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="tests")
    @Valid
    private List<EntityReference> tests = null;
    @JsonProperty(value="connection")
    @Valid
    private TestSuiteConnection connection;
    @JsonProperty(value="testConnectionResult")
    @JsonPropertyDescription(value="TestConnectionResult is the definition that will encapsulate result of running the test connection steps.")
    @Valid
    private TestConnectionResult testConnectionResult;
    @JsonProperty(value="pipelines")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> pipelines = null;
    @JsonProperty(value="serviceType")
    @JsonPropertyDescription(value="Type of database service such as MySQL, BigQuery, Snowflake, Redshift, Postgres...")
    private ServiceType serviceType = ServiceType.fromValue("TestSuite");
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double version = 0.1;
    @JsonProperty(value="updatedAt")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long updatedAt;
    @JsonProperty(value="updatedBy")
    @JsonPropertyDescription(value="User who made the update.")
    private String updatedBy;
    @JsonProperty(value="href")
    @JsonPropertyDescription(value="URI that points to a resource.")
    private URI href;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="deleted")
    @JsonPropertyDescription(value="When `true` indicates the entity has been soft deleted.")
    private Boolean deleted = false;
    @JsonProperty(value="executable")
    @JsonPropertyDescription(value="Indicates if the test suite is executable. Set on the backend.")
    private Boolean executable = false;
    @JsonProperty(value="executableEntityReference")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference executableEntityReference;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="Schema to capture test case execution summary.")
    @Valid
    private TestSummary summary;
    @JsonProperty(value="testCaseResultSummary")
    @JsonPropertyDescription(value="Summary of test case execution")
    @Valid
    private List<ResultSummary> testCaseResultSummary = new ArrayList<ResultSummary>();
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference domain;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this test suite. This is an inherited field from the parent entity if the testSuite is native.")
    @Valid
    private List<TagLabel> tags = null;

    @Override
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public TestSuite withId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public TestSuite withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public TestSuite withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public TestSuite withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TestSuite withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="tests")
    public List<EntityReference> getTests() {
        return this.tests;
    }

    @JsonProperty(value="tests")
    public void setTests(List<EntityReference> tests) {
        this.tests = tests;
    }

    public TestSuite withTests(List<EntityReference> tests) {
        this.tests = tests;
        return this;
    }

    @Override
    @JsonProperty(value="connection")
    public TestSuiteConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    public void setConnection(TestSuiteConnection connection) {
        this.connection = connection;
    }

    public TestSuite withConnection(TestSuiteConnection connection) {
        this.connection = connection;
        return this;
    }

    @JsonProperty(value="testConnectionResult")
    public TestConnectionResult getTestConnectionResult() {
        return this.testConnectionResult;
    }

    @Override
    @JsonProperty(value="testConnectionResult")
    public void setTestConnectionResult(TestConnectionResult testConnectionResult) {
        this.testConnectionResult = testConnectionResult;
    }

    public TestSuite withTestConnectionResult(TestConnectionResult testConnectionResult) {
        this.testConnectionResult = testConnectionResult;
        return this;
    }

    @JsonProperty(value="pipelines")
    public List<EntityReference> getPipelines() {
        return this.pipelines;
    }

    @Override
    @JsonProperty(value="pipelines")
    public void setPipelines(List<EntityReference> pipelines) {
        this.pipelines = pipelines;
    }

    public TestSuite withPipelines(List<EntityReference> pipelines) {
        this.pipelines = pipelines;
        return this;
    }

    @Override
    @JsonProperty(value="serviceType")
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public TestSuite withServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Override
    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @Override
    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    @Override
    public TestSuite withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    @Override
    @JsonProperty(value="version")
    public Double getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="version")
    public void setVersion(Double version) {
        this.version = version;
    }

    public TestSuite withVersion(Double version) {
        this.version = version;
        return this;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="updatedAt")
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TestSuite withUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updatedBy")
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public TestSuite withUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Override
    @JsonProperty(value="href")
    public URI getHref() {
        return this.href;
    }

    @Override
    @JsonProperty(value="href")
    public void setHref(URI href) {
        this.href = href;
    }

    public TestSuite withHref(URI href) {
        this.href = href;
        return this;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @Override
    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public TestSuite withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Override
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="deleted")
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public TestSuite withDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @JsonProperty(value="executable")
    public Boolean getExecutable() {
        return this.executable;
    }

    @JsonProperty(value="executable")
    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    public TestSuite withExecutable(Boolean executable) {
        this.executable = executable;
        return this;
    }

    @JsonProperty(value="executableEntityReference")
    public EntityReference getExecutableEntityReference() {
        return this.executableEntityReference;
    }

    @JsonProperty(value="executableEntityReference")
    public void setExecutableEntityReference(EntityReference executableEntityReference) {
        this.executableEntityReference = executableEntityReference;
    }

    public TestSuite withExecutableEntityReference(EntityReference executableEntityReference) {
        this.executableEntityReference = executableEntityReference;
        return this;
    }

    @JsonProperty(value="summary")
    public TestSummary getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(TestSummary summary) {
        this.summary = summary;
    }

    public TestSuite withSummary(TestSummary summary) {
        this.summary = summary;
        return this;
    }

    @JsonProperty(value="testCaseResultSummary")
    public List<ResultSummary> getTestCaseResultSummary() {
        return this.testCaseResultSummary;
    }

    @JsonProperty(value="testCaseResultSummary")
    public void setTestCaseResultSummary(List<ResultSummary> testCaseResultSummary) {
        this.testCaseResultSummary = testCaseResultSummary;
    }

    public TestSuite withTestCaseResultSummary(List<ResultSummary> testCaseResultSummary) {
        this.testCaseResultSummary = testCaseResultSummary;
        return this;
    }

    @Override
    @JsonProperty(value="domain")
    public EntityReference getDomain() {
        return this.domain;
    }

    @Override
    @JsonProperty(value="domain")
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public TestSuite withDomain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public TestSuite withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestSuite.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("tests");
        sb.append('=');
        sb.append(this.tests == null ? "<null>" : this.tests);
        sb.append(',');
        sb.append("connection");
        sb.append('=');
        sb.append(this.connection == null ? "<null>" : this.connection);
        sb.append(',');
        sb.append("testConnectionResult");
        sb.append('=');
        sb.append(this.testConnectionResult == null ? "<null>" : this.testConnectionResult);
        sb.append(',');
        sb.append("pipelines");
        sb.append('=');
        sb.append(this.pipelines == null ? "<null>" : this.pipelines);
        sb.append(',');
        sb.append("serviceType");
        sb.append('=');
        sb.append(this.serviceType == null ? "<null>" : this.serviceType);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("updatedAt");
        sb.append('=');
        sb.append(this.updatedAt == null ? "<null>" : this.updatedAt);
        sb.append(',');
        sb.append("updatedBy");
        sb.append('=');
        sb.append(this.updatedBy == null ? "<null>" : this.updatedBy);
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(this.href == null ? "<null>" : this.href);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("deleted");
        sb.append('=');
        sb.append(this.deleted == null ? "<null>" : this.deleted);
        sb.append(',');
        sb.append("executable");
        sb.append('=');
        sb.append(this.executable == null ? "<null>" : this.executable);
        sb.append(',');
        sb.append("executableEntityReference");
        sb.append('=');
        sb.append(this.executableEntityReference == null ? "<null>" : this.executableEntityReference);
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(this.summary == null ? "<null>" : this.summary);
        sb.append(',');
        sb.append("testCaseResultSummary");
        sb.append('=');
        sb.append(this.testCaseResultSummary == null ? "<null>" : this.testCaseResultSummary);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
        result = result * 31 + (this.executableEntityReference == null ? 0 : this.executableEntityReference.hashCode());
        result = result * 31 + (this.summary == null ? 0 : this.summary.hashCode());
        result = result * 31 + (this.updatedBy == null ? 0 : this.updatedBy.hashCode());
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.executable == null ? 0 : this.executable.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.tests == null ? 0 : this.tests.hashCode());
        result = result * 31 + (this.pipelines == null ? 0 : this.pipelines.hashCode());
        result = result * 31 + (this.deleted == null ? 0 : this.deleted.hashCode());
        result = result * 31 + (this.testConnectionResult == null ? 0 : this.testConnectionResult.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.connection == null ? 0 : this.connection.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.href == null ? 0 : this.href.hashCode());
        result = result * 31 + (this.testCaseResultSummary == null ? 0 : this.testCaseResultSummary.hashCode());
        result = result * 31 + (this.updatedAt == null ? 0 : this.updatedAt.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestSuite)) {
            return false;
        }
        TestSuite rhs = (TestSuite)other;
        return (this.serviceType == rhs.serviceType || this.serviceType != null && this.serviceType.equals(rhs.serviceType)) && (this.executableEntityReference == rhs.executableEntityReference || this.executableEntityReference != null && this.executableEntityReference.equals(rhs.executableEntityReference)) && (this.summary == rhs.summary || this.summary != null && this.summary.equals(rhs.summary)) && (this.updatedBy == rhs.updatedBy || this.updatedBy != null && this.updatedBy.equals(rhs.updatedBy)) && (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.executable == rhs.executable || this.executable != null && this.executable.equals(rhs.executable)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.tests == rhs.tests || this.tests != null && this.tests.equals(rhs.tests)) && (this.pipelines == rhs.pipelines || this.pipelines != null && this.pipelines.equals(rhs.pipelines)) && (this.deleted == rhs.deleted || this.deleted != null && this.deleted.equals(rhs.deleted)) && (this.testConnectionResult == rhs.testConnectionResult || this.testConnectionResult != null && this.testConnectionResult.equals(rhs.testConnectionResult)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.connection == rhs.connection || this.connection != null && this.connection.equals(rhs.connection)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.href == rhs.href || this.href != null && this.href.equals(rhs.href)) && (this.testCaseResultSummary == rhs.testCaseResultSummary || this.testCaseResultSummary != null && this.testCaseResultSummary.equals(rhs.testCaseResultSummary)) && (this.updatedAt == rhs.updatedAt || this.updatedAt != null && this.updatedAt.equals(rhs.updatedAt));
    }

    public static enum ServiceType implements EnumInterface
    {
        TEST_SUITE("TestSuite");

        private final String value;
        private static final Map<String, ServiceType> CONSTANTS;

        private ServiceType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @Override
        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ServiceType fromValue(String value) {
            ServiceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ServiceType>();
            for (ServiceType c : ServiceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

