/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"success", "failed", "aborted", "queued", "total", "entityLink"})
public class ColumnTestSummaryDefinition {
    @JsonProperty(value="success")
    @JsonPropertyDescription(value="Number of test cases that passed.")
    private Integer success;
    @JsonProperty(value="failed")
    @JsonPropertyDescription(value="Number of test cases that failed.")
    private Integer failed;
    @JsonProperty(value="aborted")
    @JsonPropertyDescription(value="Number of test cases that aborted.")
    private Integer aborted;
    @JsonProperty(value="queued")
    @JsonPropertyDescription(value="Number of test cases that are queued for execution.")
    private Integer queued;
    @JsonProperty(value="total")
    @JsonPropertyDescription(value="Total number of test cases.")
    private Integer total;
    @JsonProperty(value="entityLink")
    @JsonPropertyDescription(value="Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.")
    @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$")
    private @Pattern(regexp="(?U)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$") String entityLink;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="success")
    public Integer getSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    public void setSuccess(Integer success) {
        this.success = success;
    }

    public ColumnTestSummaryDefinition withSuccess(Integer success) {
        this.success = success;
        return this;
    }

    @JsonProperty(value="failed")
    public Integer getFailed() {
        return this.failed;
    }

    @JsonProperty(value="failed")
    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public ColumnTestSummaryDefinition withFailed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @JsonProperty(value="aborted")
    public Integer getAborted() {
        return this.aborted;
    }

    @JsonProperty(value="aborted")
    public void setAborted(Integer aborted) {
        this.aborted = aborted;
    }

    public ColumnTestSummaryDefinition withAborted(Integer aborted) {
        this.aborted = aborted;
        return this;
    }

    @JsonProperty(value="queued")
    public Integer getQueued() {
        return this.queued;
    }

    @JsonProperty(value="queued")
    public void setQueued(Integer queued) {
        this.queued = queued;
    }

    public ColumnTestSummaryDefinition withQueued(Integer queued) {
        this.queued = queued;
        return this;
    }

    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public ColumnTestSummaryDefinition withTotal(Integer total) {
        this.total = total;
        return this;
    }

    @JsonProperty(value="entityLink")
    public String getEntityLink() {
        return this.entityLink;
    }

    @JsonProperty(value="entityLink")
    public void setEntityLink(String entityLink) {
        this.entityLink = entityLink;
    }

    public ColumnTestSummaryDefinition withEntityLink(String entityLink) {
        this.entityLink = entityLink;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ColumnTestSummaryDefinition withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ColumnTestSummaryDefinition.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("success");
        sb.append('=');
        sb.append(this.success == null ? "<null>" : this.success);
        sb.append(',');
        sb.append("failed");
        sb.append('=');
        sb.append(this.failed == null ? "<null>" : this.failed);
        sb.append(',');
        sb.append("aborted");
        sb.append('=');
        sb.append(this.aborted == null ? "<null>" : this.aborted);
        sb.append(',');
        sb.append("queued");
        sb.append('=');
        sb.append(this.queued == null ? "<null>" : this.queued);
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(this.total == null ? "<null>" : this.total);
        sb.append(',');
        sb.append("entityLink");
        sb.append('=');
        sb.append(this.entityLink == null ? "<null>" : this.entityLink);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.total == null ? 0 : this.total.hashCode());
        result = result * 31 + (this.success == null ? 0 : this.success.hashCode());
        result = result * 31 + (this.aborted == null ? 0 : this.aborted.hashCode());
        result = result * 31 + (this.queued == null ? 0 : this.queued.hashCode());
        result = result * 31 + (this.entityLink == null ? 0 : this.entityLink.hashCode());
        result = result * 31 + (this.failed == null ? 0 : this.failed.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnTestSummaryDefinition)) {
            return false;
        }
        ColumnTestSummaryDefinition rhs = (ColumnTestSummaryDefinition)other;
        return (this.total == rhs.total || this.total != null && this.total.equals(rhs.total)) && (this.success == rhs.success || this.success != null && this.success.equals(rhs.success)) && (this.aborted == rhs.aborted || this.aborted != null && this.aborted.equals(rhs.aborted)) && (this.queued == rhs.queued || this.queued != null && this.queued.equals(rhs.queued)) && (this.entityLink == rhs.entityLink || this.entityLink != null && this.entityLink.equals(rhs.entityLink)) && (this.failed == rhs.failed || this.failed != null && this.failed.equals(rhs.failed)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

