/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.validation.Valid;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.tests.type.TestResultValue;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "testCaseStatus", "result", "sampleData", "testResultValue", "passedRows", "failedRows", "passedRowsPercentage", "failedRowsPercentage", "incidentId", "maxBound", "minBound"})
public class TestCaseResult {
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;
    @JsonProperty(value="testCaseStatus")
    @JsonPropertyDescription(value="Status of Test Case run.")
    private TestCaseStatus testCaseStatus;
    @JsonProperty(value="result")
    @JsonPropertyDescription(value="Details of test case results.")
    private String result;
    @JsonProperty(value="sampleData")
    @JsonPropertyDescription(value="sample data to capture rows/columns that didn't match the expressed testcase.")
    private String sampleData;
    @JsonProperty(value="testResultValue")
    @Valid
    private List<TestResultValue> testResultValue = new ArrayList<TestResultValue>();
    @JsonProperty(value="passedRows")
    @JsonPropertyDescription(value="Number of rows that passed.")
    private Integer passedRows;
    @JsonProperty(value="failedRows")
    @JsonPropertyDescription(value="Number of rows that failed.")
    private Integer failedRows;
    @JsonProperty(value="passedRowsPercentage")
    @JsonPropertyDescription(value="Percentage of rows that passed.")
    private Double passedRowsPercentage;
    @JsonProperty(value="failedRowsPercentage")
    @JsonPropertyDescription(value="Percentage of rows that failed.")
    private Double failedRowsPercentage;
    @JsonProperty(value="incidentId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID incidentId;
    @JsonProperty(value="maxBound")
    @JsonPropertyDescription(value="Upper bound limit for the test case result as defined in the test definition.")
    private Double maxBound;
    @JsonProperty(value="minBound")
    @JsonPropertyDescription(value="Lower bound limit for the test case result as defined in the test definition.")
    private Double minBound;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public TestCaseResult withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="testCaseStatus")
    public TestCaseStatus getTestCaseStatus() {
        return this.testCaseStatus;
    }

    @JsonProperty(value="testCaseStatus")
    public void setTestCaseStatus(TestCaseStatus testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
    }

    public TestCaseResult withTestCaseStatus(TestCaseStatus testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
        return this;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    public void setResult(String result) {
        this.result = result;
    }

    public TestCaseResult withResult(String result) {
        this.result = result;
        return this;
    }

    @JsonProperty(value="sampleData")
    public String getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    public void setSampleData(String sampleData) {
        this.sampleData = sampleData;
    }

    public TestCaseResult withSampleData(String sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @JsonProperty(value="testResultValue")
    public List<TestResultValue> getTestResultValue() {
        return this.testResultValue;
    }

    @JsonProperty(value="testResultValue")
    public void setTestResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
    }

    public TestCaseResult withTestResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
        return this;
    }

    @JsonProperty(value="passedRows")
    public Integer getPassedRows() {
        return this.passedRows;
    }

    @JsonProperty(value="passedRows")
    public void setPassedRows(Integer passedRows) {
        this.passedRows = passedRows;
    }

    public TestCaseResult withPassedRows(Integer passedRows) {
        this.passedRows = passedRows;
        return this;
    }

    @JsonProperty(value="failedRows")
    public Integer getFailedRows() {
        return this.failedRows;
    }

    @JsonProperty(value="failedRows")
    public void setFailedRows(Integer failedRows) {
        this.failedRows = failedRows;
    }

    public TestCaseResult withFailedRows(Integer failedRows) {
        this.failedRows = failedRows;
        return this;
    }

    @JsonProperty(value="passedRowsPercentage")
    public Double getPassedRowsPercentage() {
        return this.passedRowsPercentage;
    }

    @JsonProperty(value="passedRowsPercentage")
    public void setPassedRowsPercentage(Double passedRowsPercentage) {
        this.passedRowsPercentage = passedRowsPercentage;
    }

    public TestCaseResult withPassedRowsPercentage(Double passedRowsPercentage) {
        this.passedRowsPercentage = passedRowsPercentage;
        return this;
    }

    @JsonProperty(value="failedRowsPercentage")
    public Double getFailedRowsPercentage() {
        return this.failedRowsPercentage;
    }

    @JsonProperty(value="failedRowsPercentage")
    public void setFailedRowsPercentage(Double failedRowsPercentage) {
        this.failedRowsPercentage = failedRowsPercentage;
    }

    public TestCaseResult withFailedRowsPercentage(Double failedRowsPercentage) {
        this.failedRowsPercentage = failedRowsPercentage;
        return this;
    }

    @JsonProperty(value="incidentId")
    public UUID getIncidentId() {
        return this.incidentId;
    }

    @JsonProperty(value="incidentId")
    public void setIncidentId(UUID incidentId) {
        this.incidentId = incidentId;
    }

    public TestCaseResult withIncidentId(UUID incidentId) {
        this.incidentId = incidentId;
        return this;
    }

    @JsonProperty(value="maxBound")
    public Double getMaxBound() {
        return this.maxBound;
    }

    @JsonProperty(value="maxBound")
    public void setMaxBound(Double maxBound) {
        this.maxBound = maxBound;
    }

    public TestCaseResult withMaxBound(Double maxBound) {
        this.maxBound = maxBound;
        return this;
    }

    @JsonProperty(value="minBound")
    public Double getMinBound() {
        return this.minBound;
    }

    @JsonProperty(value="minBound")
    public void setMinBound(Double minBound) {
        this.minBound = minBound;
    }

    public TestCaseResult withMinBound(Double minBound) {
        this.minBound = minBound;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TestCaseResult withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestCaseResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("testCaseStatus");
        sb.append('=');
        sb.append(this.testCaseStatus == null ? "<null>" : this.testCaseStatus);
        sb.append(',');
        sb.append("result");
        sb.append('=');
        sb.append(this.result == null ? "<null>" : this.result);
        sb.append(',');
        sb.append("sampleData");
        sb.append('=');
        sb.append(this.sampleData == null ? "<null>" : this.sampleData);
        sb.append(',');
        sb.append("testResultValue");
        sb.append('=');
        sb.append(this.testResultValue == null ? "<null>" : this.testResultValue);
        sb.append(',');
        sb.append("passedRows");
        sb.append('=');
        sb.append(this.passedRows == null ? "<null>" : this.passedRows);
        sb.append(',');
        sb.append("failedRows");
        sb.append('=');
        sb.append(this.failedRows == null ? "<null>" : this.failedRows);
        sb.append(',');
        sb.append("passedRowsPercentage");
        sb.append('=');
        sb.append(this.passedRowsPercentage == null ? "<null>" : this.passedRowsPercentage);
        sb.append(',');
        sb.append("failedRowsPercentage");
        sb.append('=');
        sb.append(this.failedRowsPercentage == null ? "<null>" : this.failedRowsPercentage);
        sb.append(',');
        sb.append("incidentId");
        sb.append('=');
        sb.append(this.incidentId == null ? "<null>" : this.incidentId);
        sb.append(',');
        sb.append("maxBound");
        sb.append('=');
        sb.append(this.maxBound == null ? "<null>" : this.maxBound);
        sb.append(',');
        sb.append("minBound");
        sb.append('=');
        sb.append(this.minBound == null ? "<null>" : this.minBound);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.testCaseStatus == null ? 0 : this.testCaseStatus.hashCode());
        result = result * 31 + (this.maxBound == null ? 0 : this.maxBound.hashCode());
        result = result * 31 + (this.passedRowsPercentage == null ? 0 : this.passedRowsPercentage.hashCode());
        result = result * 31 + (this.testResultValue == null ? 0 : this.testResultValue.hashCode());
        result = result * 31 + (this.failedRowsPercentage == null ? 0 : this.failedRowsPercentage.hashCode());
        result = result * 31 + (this.passedRows == null ? 0 : this.passedRows.hashCode());
        result = result * 31 + (this.result == null ? 0 : this.result.hashCode());
        result = result * 31 + (this.sampleData == null ? 0 : this.sampleData.hashCode());
        result = result * 31 + (this.minBound == null ? 0 : this.minBound.hashCode());
        result = result * 31 + (this.failedRows == null ? 0 : this.failedRows.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.incidentId == null ? 0 : this.incidentId.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TestCaseResult)) {
            return false;
        }
        TestCaseResult rhs = (TestCaseResult)other;
        return (this.testCaseStatus == rhs.testCaseStatus || this.testCaseStatus != null && this.testCaseStatus.equals((Object)rhs.testCaseStatus)) && (this.maxBound == rhs.maxBound || this.maxBound != null && this.maxBound.equals(rhs.maxBound)) && (this.passedRowsPercentage == rhs.passedRowsPercentage || this.passedRowsPercentage != null && this.passedRowsPercentage.equals(rhs.passedRowsPercentage)) && (this.testResultValue == rhs.testResultValue || this.testResultValue != null && this.testResultValue.equals(rhs.testResultValue)) && (this.failedRowsPercentage == rhs.failedRowsPercentage || this.failedRowsPercentage != null && this.failedRowsPercentage.equals(rhs.failedRowsPercentage)) && (this.passedRows == rhs.passedRows || this.passedRows != null && this.passedRows.equals(rhs.passedRows)) && (this.result == rhs.result || this.result != null && this.result.equals(rhs.result)) && (this.sampleData == rhs.sampleData || this.sampleData != null && this.sampleData.equals(rhs.sampleData)) && (this.minBound == rhs.minBound || this.minBound != null && this.minBound.equals(rhs.minBound)) && (this.failedRows == rhs.failedRows || this.failedRows != null && this.failedRows.equals(rhs.failedRows)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.incidentId == rhs.incidentId || this.incidentId != null && this.incidentId.equals(rhs.incidentId)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

