/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.tests.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TestCaseStatus {
    Success("Success"),
    Failed("Failed"),
    Aborted("Aborted"),
    Queued("Queued");

    private final String value;
    private static final Map<String, TestCaseStatus> CONSTANTS;

    private TestCaseStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TestCaseStatus fromValue(String value) {
        TestCaseStatus constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TestCaseStatus>();
        for (TestCaseStatus c : TestCaseStatus.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

