/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum APIRequestMethod {
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    PATCH("PATCH"),
    DELETE("DELETE"),
    HEAD("HEAD"),
    CONNECT("CONNECT"),
    OPTIONS("OPTIONS"),
    TRACE("TRACE");

    private final String value;
    private static final Map<String, APIRequestMethod> CONSTANTS;

    private APIRequestMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static APIRequestMethod fromValue(String value) {
        APIRequestMethod constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, APIRequestMethod>();
        for (APIRequestMethod c : APIRequestMethod.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

