/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "accessedBy", "accessedByAProcess"})
public class AccessDetails {
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="accessedBy")
    @JsonPropertyDescription(value="This schema defines the EntityReference type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private EntityReference accessedBy;
    @JsonProperty(value="accessedByAProcess")
    @JsonPropertyDescription(value="Any process that accessed the data asset that is not captured in OpenMetadata.")
    private String accessedByAProcess = null;

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AccessDetails withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="accessedBy")
    public EntityReference getAccessedBy() {
        return this.accessedBy;
    }

    @JsonProperty(value="accessedBy")
    public void setAccessedBy(EntityReference accessedBy) {
        this.accessedBy = accessedBy;
    }

    public AccessDetails withAccessedBy(EntityReference accessedBy) {
        this.accessedBy = accessedBy;
        return this;
    }

    @JsonProperty(value="accessedByAProcess")
    public String getAccessedByAProcess() {
        return this.accessedByAProcess;
    }

    @JsonProperty(value="accessedByAProcess")
    public void setAccessedByAProcess(String accessedByAProcess) {
        this.accessedByAProcess = accessedByAProcess;
    }

    public AccessDetails withAccessedByAProcess(String accessedByAProcess) {
        this.accessedByAProcess = accessedByAProcess;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AccessDetails.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("accessedBy");
        sb.append('=');
        sb.append(this.accessedBy == null ? "<null>" : this.accessedBy);
        sb.append(',');
        sb.append("accessedByAProcess");
        sb.append('=');
        sb.append(this.accessedByAProcess == null ? "<null>" : this.accessedByAProcess);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.accessedByAProcess == null ? 0 : this.accessedByAProcess.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + (this.accessedBy == null ? 0 : this.accessedBy.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AccessDetails)) {
            return false;
        }
        AccessDetails rhs = (AccessDetails)other;
        return (this.accessedByAProcess == rhs.accessedByAProcess || this.accessedByAProcess != null && this.accessedByAProcess.equals(rhs.accessedByAProcess)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp)) && (this.accessedBy == rhs.accessedBy || this.accessedBy != null && this.accessedBy.equals(rhs.accessedBy));
    }
}

