/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ApiStatus {
    SUCCESS("success"),
    FAILURE("failure"),
    ABORTED("aborted"),
    PARTIAL_SUCCESS("partialSuccess");

    private final String value;
    private static final Map<String, ApiStatus> CONSTANTS;

    private ApiStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ApiStatus fromValue(String value) {
        ApiStatus constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ApiStatus>();
        for (ApiStatus c : ApiStatus.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

