/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"method", "responseCode", "path", "userName", "entityId", "entityType", "timestamp"})
public class AuditLog {
    @JsonProperty(value="method")
    @JsonPropertyDescription(value="HTTP Method used in a call.")
    @NotNull
    private Method method;
    @JsonProperty(value="responseCode")
    @JsonPropertyDescription(value="HTTP response code for the api requested.")
    @NotNull
    private Integer responseCode;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="Requested API Path.")
    @NotNull
    private String path;
    @JsonProperty(value="userName")
    @JsonPropertyDescription(value="Name of the user who made the API request.")
    @NotNull
    private String userName;
    @JsonProperty(value="entityId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID entityId;
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="Type of Entity that is modified by the operation.")
    @NotNull
    private String entityType;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    private Long timestamp;

    @JsonProperty(value="method")
    public Method getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(Method method) {
        this.method = method;
    }

    public AuditLog withMethod(Method method) {
        this.method = method;
        return this;
    }

    @JsonProperty(value="responseCode")
    public Integer getResponseCode() {
        return this.responseCode;
    }

    @JsonProperty(value="responseCode")
    public void setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
    }

    public AuditLog withResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public AuditLog withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public AuditLog withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @JsonProperty(value="entityId")
    public UUID getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public AuditLog withEntityId(UUID entityId) {
        this.entityId = entityId;
        return this;
    }

    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public AuditLog withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AuditLog withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuditLog.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("method");
        sb.append('=');
        sb.append(this.method == null ? "<null>" : this.method);
        sb.append(',');
        sb.append("responseCode");
        sb.append('=');
        sb.append(this.responseCode == null ? "<null>" : this.responseCode);
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(this.path == null ? "<null>" : this.path);
        sb.append(',');
        sb.append("userName");
        sb.append('=');
        sb.append(this.userName == null ? "<null>" : this.userName);
        sb.append(',');
        sb.append("entityId");
        sb.append('=');
        sb.append(this.entityId == null ? "<null>" : this.entityId);
        sb.append(',');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
        result = result * 31 + (this.method == null ? 0 : this.method.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = result * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 31 + (this.responseCode == null ? 0 : this.responseCode.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuditLog)) {
            return false;
        }
        AuditLog rhs = (AuditLog)other;
        return (this.path == rhs.path || this.path != null && this.path.equals(rhs.path)) && (this.method == rhs.method || this.method != null && this.method.equals((Object)rhs.method)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals(rhs.entityType)) && (this.entityId == rhs.entityId || this.entityId != null && this.entityId.equals(rhs.entityId)) && (this.userName == rhs.userName || this.userName != null && this.userName.equals(rhs.userName)) && (this.responseCode == rhs.responseCode || this.responseCode != null && this.responseCode.equals(rhs.responseCode)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }

    public static enum Method {
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE");

        private final String value;
        private static final Map<String, Method> CONSTANTS;

        private Method(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Method fromValue(String value) {
            Method constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Method>();
            for (Method c : Method.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

