/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.EventType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "eventType", "entityType", "entityId", "domain", "entityFullyQualifiedName", "previousVersion", "currentVersion", "userName", "timestamp", "changeDescription", "entity"})
public class ChangeEvent {
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID id;
    @JsonProperty(value="eventType")
    @JsonPropertyDescription(value="Type of event.")
    @NotNull
    private EventType eventType;
    @JsonProperty(value="entityType")
    @JsonPropertyDescription(value="Entity type that changed. Use the schema of this entity to process the entity attribute.")
    @NotNull
    private String entityType;
    @JsonProperty(value="entityId")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    @NotNull
    private UUID entityId;
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="Unique id used to identify an entity.")
    private UUID domain;
    @JsonProperty(value="entityFullyQualifiedName")
    @JsonPropertyDescription(value="Fully Qualified Name of entity that was modified by the operation.")
    private String entityFullyQualifiedName;
    @JsonProperty(value="previousVersion")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double previousVersion = 0.1;
    @JsonProperty(value="currentVersion")
    @JsonPropertyDescription(value="Metadata version of the entity in the form `Major.Minor`. First version always starts from `0.1` when the entity is created. When the backward compatible changes are made to the entity, only the `Minor` version is incremented - example `1.0` is changed to `1.1`. When backward incompatible changes are made the `Major` version is incremented - example `1.1` to `2.0`.")
    private Double currentVersion = 0.1;
    @JsonProperty(value="userName")
    @JsonPropertyDescription(value="Name of the user whose activity resulted in the change.")
    private String userName;
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="changeDescription")
    @JsonPropertyDescription(value="Description of the change.")
    @Valid
    private ChangeDescription changeDescription;
    @JsonProperty(value="entity")
    @JsonPropertyDescription(value="For `eventType` `entityCreated`, this field captures JSON coded string of the entity using the schema corresponding to `entityType`.")
    private Object entity;

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(UUID id) {
        this.id = id;
    }

    public ChangeEvent withId(UUID id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="eventType")
    public EventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="eventType")
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public ChangeEvent withEventType(EventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @JsonProperty(value="entityType")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public ChangeEvent withEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="entityId")
    public UUID getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entityId")
    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public ChangeEvent withEntityId(UUID entityId) {
        this.entityId = entityId;
        return this;
    }

    @JsonProperty(value="domain")
    public UUID getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(UUID domain) {
        this.domain = domain;
    }

    public ChangeEvent withDomain(UUID domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="entityFullyQualifiedName")
    public String getEntityFullyQualifiedName() {
        return this.entityFullyQualifiedName;
    }

    @JsonProperty(value="entityFullyQualifiedName")
    public void setEntityFullyQualifiedName(String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
    }

    public ChangeEvent withEntityFullyQualifiedName(String entityFullyQualifiedName) {
        this.entityFullyQualifiedName = entityFullyQualifiedName;
        return this;
    }

    @JsonProperty(value="previousVersion")
    public Double getPreviousVersion() {
        return this.previousVersion;
    }

    @JsonProperty(value="previousVersion")
    public void setPreviousVersion(Double previousVersion) {
        this.previousVersion = previousVersion;
    }

    public ChangeEvent withPreviousVersion(Double previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    @JsonProperty(value="currentVersion")
    public Double getCurrentVersion() {
        return this.currentVersion;
    }

    @JsonProperty(value="currentVersion")
    public void setCurrentVersion(Double currentVersion) {
        this.currentVersion = currentVersion;
    }

    public ChangeEvent withCurrentVersion(Double currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ChangeEvent withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public ChangeEvent withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="changeDescription")
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public ChangeEvent withChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @JsonProperty(value="entity")
    public Object getEntity() {
        return this.entity;
    }

    @JsonProperty(value="entity")
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public ChangeEvent withEntity(Object entity) {
        this.entity = entity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChangeEvent.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("eventType");
        sb.append('=');
        sb.append(this.eventType == null ? "<null>" : this.eventType);
        sb.append(',');
        sb.append("entityType");
        sb.append('=');
        sb.append(this.entityType == null ? "<null>" : this.entityType);
        sb.append(',');
        sb.append("entityId");
        sb.append('=');
        sb.append(this.entityId == null ? "<null>" : this.entityId);
        sb.append(',');
        sb.append("domain");
        sb.append('=');
        sb.append(this.domain == null ? "<null>" : this.domain);
        sb.append(',');
        sb.append("entityFullyQualifiedName");
        sb.append('=');
        sb.append(this.entityFullyQualifiedName == null ? "<null>" : this.entityFullyQualifiedName);
        sb.append(',');
        sb.append("previousVersion");
        sb.append('=');
        sb.append(this.previousVersion == null ? "<null>" : this.previousVersion);
        sb.append(',');
        sb.append("currentVersion");
        sb.append('=');
        sb.append(this.currentVersion == null ? "<null>" : this.currentVersion);
        sb.append(',');
        sb.append("userName");
        sb.append('=');
        sb.append(this.userName == null ? "<null>" : this.userName);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("changeDescription");
        sb.append('=');
        sb.append(this.changeDescription == null ? "<null>" : this.changeDescription);
        sb.append(',');
        sb.append("entity");
        sb.append('=');
        sb.append(this.entity == null ? "<null>" : this.entity);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.changeDescription == null ? 0 : this.changeDescription.hashCode());
        result = result * 31 + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = result * 31 + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = result * 31 + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = result * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 31 + (this.currentVersion == null ? 0 : this.currentVersion.hashCode());
        result = result * 31 + (this.entityFullyQualifiedName == null ? 0 : this.entityFullyQualifiedName.hashCode());
        result = result * 31 + (this.previousVersion == null ? 0 : this.previousVersion.hashCode());
        result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.entity == null ? 0 : this.entity.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChangeEvent)) {
            return false;
        }
        ChangeEvent rhs = (ChangeEvent)other;
        return (this.changeDescription == rhs.changeDescription || this.changeDescription != null && this.changeDescription.equals(rhs.changeDescription)) && (this.entityType == rhs.entityType || this.entityType != null && this.entityType.equals(rhs.entityType)) && (this.entityId == rhs.entityId || this.entityId != null && this.entityId.equals(rhs.entityId)) && (this.eventType == rhs.eventType || this.eventType != null && this.eventType.equals((Object)rhs.eventType)) && (this.userName == rhs.userName || this.userName != null && this.userName.equals(rhs.userName)) && (this.currentVersion == rhs.currentVersion || this.currentVersion != null && this.currentVersion.equals(rhs.currentVersion)) && (this.entityFullyQualifiedName == rhs.entityFullyQualifiedName || this.entityFullyQualifiedName != null && this.entityFullyQualifiedName.equals(rhs.entityFullyQualifiedName)) && (this.previousVersion == rhs.previousVersion || this.previousVersion != null && this.previousVersion.equals(rhs.previousVersion)) && (this.domain == rhs.domain || this.domain != null && this.domain.equals(rhs.domain)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.entity == rhs.entity || this.entity != null && this.entity.equals(rhs.entity)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

