/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.FieldInterface;
import org.openmetadata.schema.tests.CustomMetric;
import org.openmetadata.schema.type.ColumnConstraint;
import org.openmetadata.schema.type.ColumnDataType;
import org.openmetadata.schema.type.ColumnProfile;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "dataType", "arrayDataType", "dataLength", "precision", "scale", "dataTypeDisplay", "description", "fullyQualifiedName", "tags", "constraint", "ordinalPosition", "jsonSchema", "children", "profile", "customMetrics"})
public class Column
implements FieldInterface {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Local name (not fully qualified name) of the column. ColumnName is `-` when the column is not named in struct dataType. For example, BigQuery supports struct with unnamed fields.")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this column name.")
    private String displayName;
    @JsonProperty(value="dataType")
    @JsonPropertyDescription(value="This enum defines the type of data stored in a column.")
    @NotNull
    private ColumnDataType dataType;
    @JsonProperty(value="arrayDataType")
    @JsonPropertyDescription(value="This enum defines the type of data stored in a column.")
    private ColumnDataType arrayDataType;
    @JsonProperty(value="dataLength")
    @JsonPropertyDescription(value="Length of `char`, `varchar`, `binary`, `varbinary` `dataTypes`, else null. For example, `varchar(20)` has dataType as `varchar` and dataLength as `20`.")
    private Integer dataLength;
    @JsonProperty(value="precision")
    @JsonPropertyDescription(value="The precision of a numeric is the total count of significant digits in the whole number, that is, the number of digits to both sides of the decimal point. Precision is applicable Integer types, such as `INT`, `SMALLINT`, `BIGINT`, etc. It also applies to other Numeric types, such as `NUMBER`, `DECIMAL`, `DOUBLE`, `FLOAT`, etc.")
    private Integer precision;
    @JsonProperty(value="scale")
    @JsonPropertyDescription(value="The scale of a numeric is the count of decimal digits in the fractional part, to the right of the decimal point. For Integer types, the scale is `0`. It mainly applies to non Integer Numeric types, such as `NUMBER`, `DECIMAL`, `DOUBLE`, `FLOAT`, etc.")
    private Integer scale;
    @JsonProperty(value="dataTypeDisplay")
    @JsonPropertyDescription(value="Display name used for dataType. This is useful for complex types, such as `array<int>`, `map<int,string>`, `struct<>`, and union types.")
    private String dataTypeDisplay;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags associated with the column.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="constraint")
    @JsonPropertyDescription(value="This enum defines the type for column constraint.")
    private ColumnConstraint constraint = null;
    @JsonProperty(value="ordinalPosition")
    @JsonPropertyDescription(value="Ordinal position of the column.")
    private Integer ordinalPosition;
    @JsonProperty(value="jsonSchema")
    @JsonPropertyDescription(value="Json schema only if the dataType is JSON else null.")
    private String jsonSchema;
    @JsonProperty(value="children")
    @JsonPropertyDescription(value="Child columns if dataType or arrayDataType is `map`, `struct`, or `union` else `null`.")
    @Valid
    private List<Column> children = null;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="This schema defines the type to capture the table's column profile.")
    @Valid
    private ColumnProfile profile;
    @JsonProperty(value="customMetrics")
    @JsonPropertyDescription(value="List of Custom Metrics registered for a table.")
    @Valid
    private List<CustomMetric> customMetrics = null;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Column withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Column withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="dataType")
    public ColumnDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(ColumnDataType dataType) {
        this.dataType = dataType;
    }

    public Column withDataType(ColumnDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty(value="arrayDataType")
    public ColumnDataType getArrayDataType() {
        return this.arrayDataType;
    }

    @JsonProperty(value="arrayDataType")
    public void setArrayDataType(ColumnDataType arrayDataType) {
        this.arrayDataType = arrayDataType;
    }

    public Column withArrayDataType(ColumnDataType arrayDataType) {
        this.arrayDataType = arrayDataType;
        return this;
    }

    @JsonProperty(value="dataLength")
    public Integer getDataLength() {
        return this.dataLength;
    }

    @JsonProperty(value="dataLength")
    public void setDataLength(Integer dataLength) {
        this.dataLength = dataLength;
    }

    public Column withDataLength(Integer dataLength) {
        this.dataLength = dataLength;
        return this;
    }

    @JsonProperty(value="precision")
    public Integer getPrecision() {
        return this.precision;
    }

    @JsonProperty(value="precision")
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Column withPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @JsonProperty(value="scale")
    public Integer getScale() {
        return this.scale;
    }

    @JsonProperty(value="scale")
    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Column withScale(Integer scale) {
        this.scale = scale;
        return this;
    }

    @Override
    @JsonProperty(value="dataTypeDisplay")
    public String getDataTypeDisplay() {
        return this.dataTypeDisplay;
    }

    @JsonProperty(value="dataTypeDisplay")
    public void setDataTypeDisplay(String dataTypeDisplay) {
        this.dataTypeDisplay = dataTypeDisplay;
    }

    public Column withDataTypeDisplay(String dataTypeDisplay) {
        this.dataTypeDisplay = dataTypeDisplay;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Column withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Column withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public Column withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="constraint")
    public ColumnConstraint getConstraint() {
        return this.constraint;
    }

    @JsonProperty(value="constraint")
    public void setConstraint(ColumnConstraint constraint) {
        this.constraint = constraint;
    }

    public Column withConstraint(ColumnConstraint constraint) {
        this.constraint = constraint;
        return this;
    }

    @JsonProperty(value="ordinalPosition")
    public Integer getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty(value="ordinalPosition")
    public void setOrdinalPosition(Integer ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public Column withOrdinalPosition(Integer ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
        return this;
    }

    @JsonProperty(value="jsonSchema")
    public String getJsonSchema() {
        return this.jsonSchema;
    }

    @JsonProperty(value="jsonSchema")
    public void setJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public Column withJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    @JsonProperty(value="children")
    public List<Column> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    public void setChildren(List<Column> children) {
        this.children = children;
    }

    public Column withChildren(List<Column> children) {
        this.children = children;
        return this;
    }

    @JsonProperty(value="profile")
    public ColumnProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    public void setProfile(ColumnProfile profile) {
        this.profile = profile;
    }

    public Column withProfile(ColumnProfile profile) {
        this.profile = profile;
        return this;
    }

    @JsonProperty(value="customMetrics")
    public List<CustomMetric> getCustomMetrics() {
        return this.customMetrics;
    }

    @JsonProperty(value="customMetrics")
    public void setCustomMetrics(List<CustomMetric> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public Column withCustomMetrics(List<CustomMetric> customMetrics) {
        this.customMetrics = customMetrics;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Column.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("arrayDataType");
        sb.append('=');
        sb.append(this.arrayDataType == null ? "<null>" : this.arrayDataType);
        sb.append(',');
        sb.append("dataLength");
        sb.append('=');
        sb.append(this.dataLength == null ? "<null>" : this.dataLength);
        sb.append(',');
        sb.append("precision");
        sb.append('=');
        sb.append(this.precision == null ? "<null>" : this.precision);
        sb.append(',');
        sb.append("scale");
        sb.append('=');
        sb.append(this.scale == null ? "<null>" : this.scale);
        sb.append(',');
        sb.append("dataTypeDisplay");
        sb.append('=');
        sb.append(this.dataTypeDisplay == null ? "<null>" : this.dataTypeDisplay);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("constraint");
        sb.append('=');
        sb.append(this.constraint == null ? "<null>" : this.constraint);
        sb.append(',');
        sb.append("ordinalPosition");
        sb.append('=');
        sb.append(this.ordinalPosition == null ? "<null>" : this.ordinalPosition);
        sb.append(',');
        sb.append("jsonSchema");
        sb.append('=');
        sb.append(this.jsonSchema == null ? "<null>" : this.jsonSchema);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        sb.append("profile");
        sb.append('=');
        sb.append(this.profile == null ? "<null>" : this.profile);
        sb.append(',');
        sb.append("customMetrics");
        sb.append('=');
        sb.append(this.customMetrics == null ? "<null>" : this.customMetrics);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.dataLength == null ? 0 : this.dataLength.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = result * 31 + (this.precision == null ? 0 : this.precision.hashCode());
        result = result * 31 + (this.profile == null ? 0 : this.profile.hashCode());
        result = result * 31 + (this.scale == null ? 0 : this.scale.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.ordinalPosition == null ? 0 : this.ordinalPosition.hashCode());
        result = result * 31 + (this.dataTypeDisplay == null ? 0 : this.dataTypeDisplay.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.customMetrics == null ? 0 : this.customMetrics.hashCode());
        result = result * 31 + (this.jsonSchema == null ? 0 : this.jsonSchema.hashCode());
        result = result * 31 + (this.children == null ? 0 : this.children.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.constraint == null ? 0 : this.constraint.hashCode());
        result = result * 31 + (this.arrayDataType == null ? 0 : this.arrayDataType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        Column rhs = (Column)other;
        return (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.dataLength == rhs.dataLength || this.dataLength != null && this.dataLength.equals(rhs.dataLength)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType)) && (this.precision == rhs.precision || this.precision != null && this.precision.equals(rhs.precision)) && (this.profile == rhs.profile || this.profile != null && this.profile.equals(rhs.profile)) && (this.scale == rhs.scale || this.scale != null && this.scale.equals(rhs.scale)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.ordinalPosition == rhs.ordinalPosition || this.ordinalPosition != null && this.ordinalPosition.equals(rhs.ordinalPosition)) && (this.dataTypeDisplay == rhs.dataTypeDisplay || this.dataTypeDisplay != null && this.dataTypeDisplay.equals(rhs.dataTypeDisplay)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.customMetrics == rhs.customMetrics || this.customMetrics != null && this.customMetrics.equals(rhs.customMetrics)) && (this.jsonSchema == rhs.jsonSchema || this.jsonSchema != null && this.jsonSchema.equals(rhs.jsonSchema)) && (this.children == rhs.children || this.children != null && this.children.equals(rhs.children)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.constraint == rhs.constraint || this.constraint != null && this.constraint.equals((Object)rhs.constraint)) && (this.arrayDataType == rhs.arrayDataType || this.arrayDataType != null && this.arrayDataType.equals((Object)rhs.arrayDataType));
    }
}

