/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ColumnConstraint {
    NULL("NULL"),
    NOT_NULL("NOT_NULL"),
    UNIQUE("UNIQUE"),
    PRIMARY_KEY("PRIMARY_KEY");

    private final String value;
    private static final Map<String, ColumnConstraint> CONSTANTS;

    private ColumnConstraint(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ColumnConstraint fromValue(String value) {
        ColumnConstraint constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ColumnConstraint>();
        for (ColumnConstraint c : ColumnConstraint.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

