/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Column;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"isPartitioned", "columns"})
public class ContainerDataModel {
    @JsonProperty(value="isPartitioned")
    @JsonPropertyDescription(value="Whether the data under this container is partitioned by some property, eg. eventTime=yyyy-mm-dd")
    private Boolean isPartitioned = false;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="Columns belonging to this container's schema")
    @Valid
    @NotNull
    private List<Column> columns = new ArrayList<Column>();

    @JsonProperty(value="isPartitioned")
    public Boolean getIsPartitioned() {
        return this.isPartitioned;
    }

    @JsonProperty(value="isPartitioned")
    public void setIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
    }

    public ContainerDataModel withIsPartitioned(Boolean isPartitioned) {
        this.isPartitioned = isPartitioned;
        return this;
    }

    @JsonProperty(value="columns")
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public ContainerDataModel withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ContainerDataModel.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("isPartitioned");
        sb.append('=');
        sb.append(this.isPartitioned == null ? "<null>" : this.isPartitioned);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.isPartitioned == null ? 0 : this.isPartitioned.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ContainerDataModel)) {
            return false;
        }
        ContainerDataModel rhs = (ContainerDataModel)other;
        return (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.isPartitioned == rhs.isPartitioned || this.isPartitioned != null && this.isPartitioned.equals(rhs.isPartitioned));
    }
}

