/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DashboardType {
    Dashboard("Dashboard"),
    Report("Report");

    private final String value;
    private static final Map<String, DashboardType> CONSTANTS;

    private DashboardType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static DashboardType fromValue(String value) {
        DashboardType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DashboardType>();
        for (DashboardType c : DashboardType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

