/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"username", "password", "hostPort", "database", "schema", "includeViews", "includeTables", "generateSampleData", "sampleDataQuery", "enableDataProfiler", "includeFilterPattern", "excludeFilterPattern"})
public class DatabaseConnectionConfig {
    @JsonProperty(value="username")
    @JsonPropertyDescription(value="username to connect  to the data source.")
    private String username;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="password to connect  to the data source.")
    private String password;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Host and port of the data source.")
    private String hostPort;
    @JsonProperty(value="database")
    @JsonPropertyDescription(value="Database of the data source.")
    private String database;
    @JsonProperty(value="schema")
    @JsonPropertyDescription(value="schema of the data source.")
    private String schema;
    @JsonProperty(value="includeViews")
    @JsonPropertyDescription(value="optional configuration to turn off fetching metadata for views.")
    private Boolean includeViews = true;
    @JsonProperty(value="includeTables")
    @JsonPropertyDescription(value="Optional configuration to turn off fetching metadata for tables.")
    private Boolean includeTables = true;
    @JsonProperty(value="generateSampleData")
    @JsonPropertyDescription(value="Turn on/off collecting sample data.")
    private Boolean generateSampleData = true;
    @JsonProperty(value="sampleDataQuery")
    @JsonPropertyDescription(value="query to generate sample data.")
    private String sampleDataQuery = "select * from {}.{} limit 50";
    @JsonProperty(value="enableDataProfiler")
    @JsonPropertyDescription(value="Run data profiler as part of ingestion to get table profile data.")
    private Boolean enableDataProfiler = false;
    @JsonProperty(value="includeFilterPattern")
    @JsonPropertyDescription(value="Regex to only fetch tables or databases that matches the pattern.")
    @Valid
    private List<String> includeFilterPattern = null;
    @JsonProperty(value="excludeFilterPattern")
    @JsonPropertyDescription(value="Regex exclude tables or databases that matches the pattern.")
    @Valid
    private List<String> excludeFilterPattern = null;

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    public DatabaseConnectionConfig withUsername(String username) {
        this.username = username;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public DatabaseConnectionConfig withPassword(String password) {
        this.password = password;
        return this;
    }

    @JsonProperty(value="hostPort")
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public DatabaseConnectionConfig withHostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @JsonProperty(value="database")
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty(value="database")
    public void setDatabase(String database) {
        this.database = database;
    }

    public DatabaseConnectionConfig withDatabase(String database) {
        this.database = database;
        return this;
    }

    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    public DatabaseConnectionConfig withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    @JsonProperty(value="includeViews")
    public Boolean getIncludeViews() {
        return this.includeViews;
    }

    @JsonProperty(value="includeViews")
    public void setIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
    }

    public DatabaseConnectionConfig withIncludeViews(Boolean includeViews) {
        this.includeViews = includeViews;
        return this;
    }

    @JsonProperty(value="includeTables")
    public Boolean getIncludeTables() {
        return this.includeTables;
    }

    @JsonProperty(value="includeTables")
    public void setIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
    }

    public DatabaseConnectionConfig withIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    @JsonProperty(value="generateSampleData")
    public Boolean getGenerateSampleData() {
        return this.generateSampleData;
    }

    @JsonProperty(value="generateSampleData")
    public void setGenerateSampleData(Boolean generateSampleData) {
        this.generateSampleData = generateSampleData;
    }

    public DatabaseConnectionConfig withGenerateSampleData(Boolean generateSampleData) {
        this.generateSampleData = generateSampleData;
        return this;
    }

    @JsonProperty(value="sampleDataQuery")
    public String getSampleDataQuery() {
        return this.sampleDataQuery;
    }

    @JsonProperty(value="sampleDataQuery")
    public void setSampleDataQuery(String sampleDataQuery) {
        this.sampleDataQuery = sampleDataQuery;
    }

    public DatabaseConnectionConfig withSampleDataQuery(String sampleDataQuery) {
        this.sampleDataQuery = sampleDataQuery;
        return this;
    }

    @JsonProperty(value="enableDataProfiler")
    public Boolean getEnableDataProfiler() {
        return this.enableDataProfiler;
    }

    @JsonProperty(value="enableDataProfiler")
    public void setEnableDataProfiler(Boolean enableDataProfiler) {
        this.enableDataProfiler = enableDataProfiler;
    }

    public DatabaseConnectionConfig withEnableDataProfiler(Boolean enableDataProfiler) {
        this.enableDataProfiler = enableDataProfiler;
        return this;
    }

    @JsonProperty(value="includeFilterPattern")
    public List<String> getIncludeFilterPattern() {
        return this.includeFilterPattern;
    }

    @JsonProperty(value="includeFilterPattern")
    public void setIncludeFilterPattern(List<String> includeFilterPattern) {
        this.includeFilterPattern = includeFilterPattern;
    }

    public DatabaseConnectionConfig withIncludeFilterPattern(List<String> includeFilterPattern) {
        this.includeFilterPattern = includeFilterPattern;
        return this;
    }

    @JsonProperty(value="excludeFilterPattern")
    public List<String> getExcludeFilterPattern() {
        return this.excludeFilterPattern;
    }

    @JsonProperty(value="excludeFilterPattern")
    public void setExcludeFilterPattern(List<String> excludeFilterPattern) {
        this.excludeFilterPattern = excludeFilterPattern;
    }

    public DatabaseConnectionConfig withExcludeFilterPattern(List<String> excludeFilterPattern) {
        this.excludeFilterPattern = excludeFilterPattern;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseConnectionConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("username");
        sb.append('=');
        sb.append(this.username == null ? "<null>" : this.username);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("hostPort");
        sb.append('=');
        sb.append(this.hostPort == null ? "<null>" : this.hostPort);
        sb.append(',');
        sb.append("database");
        sb.append('=');
        sb.append(this.database == null ? "<null>" : this.database);
        sb.append(',');
        sb.append("schema");
        sb.append('=');
        sb.append(this.schema == null ? "<null>" : this.schema);
        sb.append(',');
        sb.append("includeViews");
        sb.append('=');
        sb.append(this.includeViews == null ? "<null>" : this.includeViews);
        sb.append(',');
        sb.append("includeTables");
        sb.append('=');
        sb.append(this.includeTables == null ? "<null>" : this.includeTables);
        sb.append(',');
        sb.append("generateSampleData");
        sb.append('=');
        sb.append(this.generateSampleData == null ? "<null>" : this.generateSampleData);
        sb.append(',');
        sb.append("sampleDataQuery");
        sb.append('=');
        sb.append(this.sampleDataQuery == null ? "<null>" : this.sampleDataQuery);
        sb.append(',');
        sb.append("enableDataProfiler");
        sb.append('=');
        sb.append(this.enableDataProfiler == null ? "<null>" : this.enableDataProfiler);
        sb.append(',');
        sb.append("includeFilterPattern");
        sb.append('=');
        sb.append(this.includeFilterPattern == null ? "<null>" : this.includeFilterPattern);
        sb.append(',');
        sb.append("excludeFilterPattern");
        sb.append('=');
        sb.append(this.excludeFilterPattern == null ? "<null>" : this.excludeFilterPattern);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.schema == null ? 0 : this.schema.hashCode());
        result = result * 31 + (this.includeViews == null ? 0 : this.includeViews.hashCode());
        result = result * 31 + (this.includeTables == null ? 0 : this.includeTables.hashCode());
        result = result * 31 + (this.sampleDataQuery == null ? 0 : this.sampleDataQuery.hashCode());
        result = result * 31 + (this.generateSampleData == null ? 0 : this.generateSampleData.hashCode());
        result = result * 31 + (this.includeFilterPattern == null ? 0 : this.includeFilterPattern.hashCode());
        result = result * 31 + (this.excludeFilterPattern == null ? 0 : this.excludeFilterPattern.hashCode());
        result = result * 31 + (this.enableDataProfiler == null ? 0 : this.enableDataProfiler.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.hostPort == null ? 0 : this.hostPort.hashCode());
        result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseConnectionConfig)) {
            return false;
        }
        DatabaseConnectionConfig rhs = (DatabaseConnectionConfig)other;
        return (this.schema == rhs.schema || this.schema != null && this.schema.equals(rhs.schema)) && (this.includeViews == rhs.includeViews || this.includeViews != null && this.includeViews.equals(rhs.includeViews)) && (this.includeTables == rhs.includeTables || this.includeTables != null && this.includeTables.equals(rhs.includeTables)) && (this.sampleDataQuery == rhs.sampleDataQuery || this.sampleDataQuery != null && this.sampleDataQuery.equals(rhs.sampleDataQuery)) && (this.generateSampleData == rhs.generateSampleData || this.generateSampleData != null && this.generateSampleData.equals(rhs.generateSampleData)) && (this.includeFilterPattern == rhs.includeFilterPattern || this.includeFilterPattern != null && this.includeFilterPattern.equals(rhs.includeFilterPattern)) && (this.excludeFilterPattern == rhs.excludeFilterPattern || this.excludeFilterPattern != null && this.excludeFilterPattern.equals(rhs.excludeFilterPattern)) && (this.enableDataProfiler == rhs.enableDataProfiler || this.enableDataProfiler != null && this.enableDataProfiler.equals(rhs.enableDataProfiler)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.database == rhs.database || this.database != null && this.database.equals(rhs.database)) && (this.hostPort == rhs.hostPort || this.hostPort != null && this.hostPort.equals(rhs.hostPort)) && (this.username == rhs.username || this.username != null && this.username.equals(rhs.username));
    }
}

