/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.services.connections.database.SampleDataStorageConfig;
import org.openmetadata.schema.type.TableProfilerConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"profileSample", "profileSampleType", "sampleDataCount", "sampleDataStorageConfig"})
public class DatabaseSchemaProfilerConfig {
    @JsonProperty(value="profileSample")
    @JsonPropertyDescription(value="Percentage of data or no. of rows we want to execute the profiler and tests on")
    private Double profileSample = null;
    @JsonProperty(value="profileSampleType")
    @JsonPropertyDescription(value="Type of Profile Sample (percentage or rows)")
    private TableProfilerConfig.ProfileSampleType profileSampleType = TableProfilerConfig.ProfileSampleType.fromValue("PERCENTAGE");
    @JsonProperty(value="sampleDataCount")
    @JsonPropertyDescription(value="Number of row of sample data to be generated")
    private Integer sampleDataCount = 50;
    @JsonProperty(value="sampleDataStorageConfig")
    @JsonPropertyDescription(value="Storage config to store sample data")
    @Valid
    private SampleDataStorageConfig sampleDataStorageConfig;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="profileSample")
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public DatabaseSchemaProfilerConfig withProfileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @JsonProperty(value="profileSampleType")
    public TableProfilerConfig.ProfileSampleType getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    public void setProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public DatabaseSchemaProfilerConfig withProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @JsonProperty(value="sampleDataCount")
    public Integer getSampleDataCount() {
        return this.sampleDataCount;
    }

    @JsonProperty(value="sampleDataCount")
    public void setSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
    }

    public DatabaseSchemaProfilerConfig withSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
        return this;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public SampleDataStorageConfig getSampleDataStorageConfig() {
        return this.sampleDataStorageConfig;
    }

    @JsonProperty(value="sampleDataStorageConfig")
    public void setSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
    }

    public DatabaseSchemaProfilerConfig withSampleDataStorageConfig(SampleDataStorageConfig sampleDataStorageConfig) {
        this.sampleDataStorageConfig = sampleDataStorageConfig;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DatabaseSchemaProfilerConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DatabaseSchemaProfilerConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("profileSample");
        sb.append('=');
        sb.append(this.profileSample == null ? "<null>" : this.profileSample);
        sb.append(',');
        sb.append("profileSampleType");
        sb.append('=');
        sb.append(this.profileSampleType == null ? "<null>" : this.profileSampleType);
        sb.append(',');
        sb.append("sampleDataCount");
        sb.append('=');
        sb.append(this.sampleDataCount == null ? "<null>" : this.sampleDataCount);
        sb.append(',');
        sb.append("sampleDataStorageConfig");
        sb.append('=');
        sb.append(this.sampleDataStorageConfig == null ? "<null>" : this.sampleDataStorageConfig);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sampleDataStorageConfig == null ? 0 : this.sampleDataStorageConfig.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.sampleDataCount == null ? 0 : this.sampleDataCount.hashCode());
        result = result * 31 + (this.profileSample == null ? 0 : this.profileSample.hashCode());
        result = result * 31 + (this.profileSampleType == null ? 0 : this.profileSampleType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DatabaseSchemaProfilerConfig)) {
            return false;
        }
        DatabaseSchemaProfilerConfig rhs = (DatabaseSchemaProfilerConfig)other;
        return (this.sampleDataStorageConfig == rhs.sampleDataStorageConfig || this.sampleDataStorageConfig != null && this.sampleDataStorageConfig.equals(rhs.sampleDataStorageConfig)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.sampleDataCount == rhs.sampleDataCount || this.sampleDataCount != null && this.sampleDataCount.equals(rhs.sampleDataCount)) && (this.profileSample == rhs.profileSample || this.profileSample != null && this.profileSample.equals(rhs.profileSample)) && (this.profileSampleType == rhs.profileSampleType || this.profileSampleType != null && this.profileSampleType.equals((Object)rhs.profileSampleType));
    }
}

