/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.type.ParamAdditionalContext;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "input", "description", "examples", "parameterInputType", "paramAdditionalContext"})
public class Function {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the function.")
    private String name;
    @JsonProperty(value="input")
    @JsonPropertyDescription(value="Description of input taken by the function.")
    private String input;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description for the function.")
    private String description;
    @JsonProperty(value="examples")
    @JsonPropertyDescription(value="Examples of the function to help users author conditions.")
    @Valid
    private List<Object> examples = new ArrayList<Object>();
    @JsonProperty(value="parameterInputType")
    private ParameterType parameterInputType;
    @JsonProperty(value="paramAdditionalContext")
    @JsonPropertyDescription(value="Additional Context")
    @Valid
    private ParamAdditionalContext paramAdditionalContext;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Function withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="input")
    public String getInput() {
        return this.input;
    }

    @JsonProperty(value="input")
    public void setInput(String input) {
        this.input = input;
    }

    public Function withInput(String input) {
        this.input = input;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Function withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="examples")
    public List<Object> getExamples() {
        return this.examples;
    }

    @JsonProperty(value="examples")
    public void setExamples(List<Object> examples) {
        this.examples = examples;
    }

    public Function withExamples(List<Object> examples) {
        this.examples = examples;
        return this;
    }

    @JsonProperty(value="parameterInputType")
    public ParameterType getParameterInputType() {
        return this.parameterInputType;
    }

    @JsonProperty(value="parameterInputType")
    public void setParameterInputType(ParameterType parameterInputType) {
        this.parameterInputType = parameterInputType;
    }

    public Function withParameterInputType(ParameterType parameterInputType) {
        this.parameterInputType = parameterInputType;
        return this;
    }

    @JsonProperty(value="paramAdditionalContext")
    public ParamAdditionalContext getParamAdditionalContext() {
        return this.paramAdditionalContext;
    }

    @JsonProperty(value="paramAdditionalContext")
    public void setParamAdditionalContext(ParamAdditionalContext paramAdditionalContext) {
        this.paramAdditionalContext = paramAdditionalContext;
    }

    public Function withParamAdditionalContext(ParamAdditionalContext paramAdditionalContext) {
        this.paramAdditionalContext = paramAdditionalContext;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Function.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("input");
        sb.append('=');
        sb.append(this.input == null ? "<null>" : this.input);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("examples");
        sb.append('=');
        sb.append(this.examples == null ? "<null>" : this.examples);
        sb.append(',');
        sb.append("parameterInputType");
        sb.append('=');
        sb.append(this.parameterInputType == null ? "<null>" : this.parameterInputType);
        sb.append(',');
        sb.append("paramAdditionalContext");
        sb.append('=');
        sb.append(this.paramAdditionalContext == null ? "<null>" : this.paramAdditionalContext);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.input == null ? 0 : this.input.hashCode());
        result = result * 31 + (this.examples == null ? 0 : this.examples.hashCode());
        result = result * 31 + (this.paramAdditionalContext == null ? 0 : this.paramAdditionalContext.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.parameterInputType == null ? 0 : this.parameterInputType.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Function)) {
            return false;
        }
        Function rhs = (Function)other;
        return (this.input == rhs.input || this.input != null && this.input.equals(rhs.input)) && (this.examples == rhs.examples || this.examples != null && this.examples.equals(rhs.examples)) && (this.paramAdditionalContext == rhs.paramAdditionalContext || this.paramAdditionalContext != null && this.paramAdditionalContext.equals(rhs.paramAdditionalContext)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.parameterInputType == rhs.parameterInputType || this.parameterInputType != null && this.parameterInputType.equals((Object)rhs.parameterInputType));
    }

    public static enum ParameterType {
        NOT_REQUIRED("NotRequired"),
        ALL_INDEX_ELASTIC_SEARCH("AllIndexElasticSearch"),
        SPECIFIC_INDEX_ELASTIC_SEARCH("SpecificIndexElasticSearch"),
        READ_FROM_PARAM_CONTEXT("ReadFromParamContext"),
        READ_FROM_PARAM_CONTEXT_PER_ENTITY("ReadFromParamContextPerEntity");

        private final String value;
        private static final Map<String, ParameterType> CONSTANTS;

        private ParameterType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ParameterType fromValue(String value) {
            ParameterType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ParameterType>();
            for (ParameterType c : ParameterType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

