/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"driverClass", "connectionUrl", "userName", "password"})
public class JdbcConnection {
    @JsonProperty(value="driverClass")
    @JsonPropertyDescription(value="Type used for JDBC driver class.")
    @NotNull
    private String driverClass;
    @JsonProperty(value="connectionUrl")
    @JsonPropertyDescription(value="Type used for JDBC connection URL of format `url_scheme://<username>:<password>@<host>:<port>/<db_name>`.")
    @NotNull
    private String connectionUrl;
    @JsonProperty(value="userName")
    @JsonPropertyDescription(value="Login user name.")
    @NotNull
    private String userName;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Login password.")
    @NotNull
    private String password;

    @JsonProperty(value="driverClass")
    public String getDriverClass() {
        return this.driverClass;
    }

    @JsonProperty(value="driverClass")
    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public JdbcConnection withDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    @JsonProperty(value="connectionUrl")
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @JsonProperty(value="connectionUrl")
    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public JdbcConnection withConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public JdbcConnection withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public JdbcConnection withPassword(String password) {
        this.password = password;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JdbcConnection.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("driverClass");
        sb.append('=');
        sb.append(this.driverClass == null ? "<null>" : this.driverClass);
        sb.append(',');
        sb.append("connectionUrl");
        sb.append('=');
        sb.append(this.connectionUrl == null ? "<null>" : this.connectionUrl);
        sb.append(',');
        sb.append("userName");
        sb.append('=');
        sb.append(this.userName == null ? "<null>" : this.userName);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.connectionUrl == null ? 0 : this.connectionUrl.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 31 + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof JdbcConnection)) {
            return false;
        }
        JdbcConnection rhs = (JdbcConnection)other;
        return (this.connectionUrl == rhs.connectionUrl || this.connectionUrl != null && this.connectionUrl.equals(rhs.connectionUrl)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.userName == rhs.userName || this.userName != null && this.userName.equals(rhs.userName)) && (this.driverClass == rhs.driverClass || this.driverClass != null && this.driverClass.equals(rhs.driverClass));
    }
}

