/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MetadataOperation {
    ALL("All"),
    CREATE("Create"),
    CREATE_INGESTION_PIPELINE_AUTOMATOR("CreateIngestionPipelineAutomator"),
    DELETE("Delete"),
    VIEW_ALL("ViewAll"),
    VIEW_BASIC("ViewBasic"),
    VIEW_USAGE("ViewUsage"),
    VIEW_TESTS("ViewTests"),
    VIEW_QUERIES("ViewQueries"),
    VIEW_DATA_PROFILE("ViewDataProfile"),
    VIEW_SAMPLE_DATA("ViewSampleData"),
    VIEW_TEST_CASE_FAILED_ROWS_SAMPLE("ViewTestCaseFailedRowsSample"),
    EDIT_ALL("EditAll"),
    EDIT_CUSTOM_FIELDS("EditCustomFields"),
    EDIT_DATA_PROFILE("EditDataProfile"),
    EDIT_DESCRIPTION("EditDescription"),
    EDIT_DISPLAY_NAME("EditDisplayName"),
    EDIT_LINEAGE("EditLineage"),
    EDIT_POLICY("EditPolicy"),
    EDIT_OWNERS("EditOwners"),
    EDIT_QUERIES("EditQueries"),
    EDIT_REVIEWERS("EditReviewers"),
    EDIT_ROLE("EditRole"),
    EDIT_SAMPLE_DATA("EditSampleData"),
    EDIT_STATUS("EditStatus"),
    EDIT_TAGS("EditTags"),
    EDIT_TEAMS("EditTeams"),
    EDIT_TIER("EditTier"),
    EDIT_TESTS("EditTests"),
    EDIT_USAGE("EditUsage"),
    EDIT_USERS("EditUsers"),
    EDIT_LIFE_CYCLE("EditLifeCycle"),
    EDIT_KNOWLEDGE_PANEL("EditKnowledgePanel"),
    EDIT_PAGE("EditPage"),
    EDIT_INGESTION_PIPELINE_STATUS("EditIngestionPipelineStatus"),
    DELETE_TEST_CASE_FAILED_ROWS_SAMPLE("DeleteTestCaseFailedRowsSample"),
    DEPLOY("Deploy"),
    TRIGGER("Trigger"),
    KILL("Kill"),
    GENERATE_TOKEN("GenerateToken");

    private final String value;
    private static final Map<String, MetadataOperation> CONSTANTS;

    private MetadataOperation(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MetadataOperation fromValue(String value) {
        MetadataOperation constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, MetadataOperation>();
        for (MetadataOperation c : MetadataOperation.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

