/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.openmetadata.schema.type.NotificationFilterOperation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "supportedFilters"})
public class NotificationResourceDescriptor {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the resource. For entity related resources, resource name is same as the entity name. Some resources such as lineage are not entities but are resources.")
    private String name;
    @JsonProperty(value="supportedFilters")
    @JsonPropertyDescription(value="List of operations supported filters by the resource.")
    @Valid
    private List<NotificationFilterOperation> supportedFilters = new ArrayList<NotificationFilterOperation>();

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public NotificationResourceDescriptor withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="supportedFilters")
    public List<NotificationFilterOperation> getSupportedFilters() {
        return this.supportedFilters;
    }

    @JsonProperty(value="supportedFilters")
    public void setSupportedFilters(List<NotificationFilterOperation> supportedFilters) {
        this.supportedFilters = supportedFilters;
    }

    public NotificationResourceDescriptor withSupportedFilters(List<NotificationFilterOperation> supportedFilters) {
        this.supportedFilters = supportedFilters;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(NotificationResourceDescriptor.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("supportedFilters");
        sb.append('=');
        sb.append(this.supportedFilters == null ? "<null>" : this.supportedFilters);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.supportedFilters == null ? 0 : this.supportedFilters.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof NotificationResourceDescriptor)) {
            return false;
        }
        NotificationResourceDescriptor rhs = (NotificationResourceDescriptor)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.supportedFilters == rhs.supportedFilters || this.supportedFilters != null && this.supportedFilters.equals(rhs.supportedFilters));
    }
}

