/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Joins;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"tables", "databaseName", "joins", "sql", "dialect", "query_type", "exclude_usage", "serviceName", "userName", "date", "databaseSchema", "duration"})
public class ParsedData {
    @JsonProperty(value="tables")
    @JsonPropertyDescription(value="List of tables used in query")
    @Valid
    @NotNull
    private List<String> tables = new ArrayList<String>();
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Database associated with the table in the query")
    private String databaseName;
    @JsonProperty(value="joins")
    @JsonPropertyDescription(value="Maps each parsed table name of a query to the join information")
    @Valid
    private Joins joins;
    @JsonProperty(value="sql")
    @JsonPropertyDescription(value="SQL query")
    @NotNull
    private String sql;
    @JsonProperty(value="dialect")
    @JsonPropertyDescription(value="SQL dialect")
    private String dialect;
    @JsonProperty(value="query_type")
    @JsonPropertyDescription(value="SQL query type")
    private String queryType;
    @JsonProperty(value="exclude_usage")
    @JsonPropertyDescription(value="Flag to check if query is to be excluded while processing usage")
    private Boolean excludeUsage;
    @JsonProperty(value="serviceName")
    @JsonPropertyDescription(value="Name that identifies this database service.")
    @NotNull
    private String serviceName;
    @JsonProperty(value="userName")
    @JsonPropertyDescription(value="Name of the user that executed the SQL query")
    private String userName;
    @JsonProperty(value="date")
    @JsonPropertyDescription(value="Date of execution of SQL query")
    private String date;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="Database schema of the associated with query")
    private String databaseSchema;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="How long did the query took to run in milliseconds.")
    private Double duration;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="tables")
    public List<String> getTables() {
        return this.tables;
    }

    @JsonProperty(value="tables")
    public void setTables(List<String> tables) {
        this.tables = tables;
    }

    public ParsedData withTables(List<String> tables) {
        this.tables = tables;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public ParsedData withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="joins")
    public Joins getJoins() {
        return this.joins;
    }

    @JsonProperty(value="joins")
    public void setJoins(Joins joins) {
        this.joins = joins;
    }

    public ParsedData withJoins(Joins joins) {
        this.joins = joins;
        return this;
    }

    @JsonProperty(value="sql")
    public String getSql() {
        return this.sql;
    }

    @JsonProperty(value="sql")
    public void setSql(String sql) {
        this.sql = sql;
    }

    public ParsedData withSql(String sql) {
        this.sql = sql;
        return this;
    }

    @JsonProperty(value="dialect")
    public String getDialect() {
        return this.dialect;
    }

    @JsonProperty(value="dialect")
    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public ParsedData withDialect(String dialect) {
        this.dialect = dialect;
        return this;
    }

    @JsonProperty(value="query_type")
    public String getQueryType() {
        return this.queryType;
    }

    @JsonProperty(value="query_type")
    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public ParsedData withQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    @JsonProperty(value="exclude_usage")
    public Boolean getExcludeUsage() {
        return this.excludeUsage;
    }

    @JsonProperty(value="exclude_usage")
    public void setExcludeUsage(Boolean excludeUsage) {
        this.excludeUsage = excludeUsage;
    }

    public ParsedData withExcludeUsage(Boolean excludeUsage) {
        this.excludeUsage = excludeUsage;
        return this;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public ParsedData withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ParsedData withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    public void setDate(String date) {
        this.date = date;
    }

    public ParsedData withDate(String date) {
        this.date = date;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public ParsedData withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="duration")
    public Double getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public ParsedData withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ParsedData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ParsedData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("tables");
        sb.append('=');
        sb.append(this.tables == null ? "<null>" : this.tables);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("joins");
        sb.append('=');
        sb.append(this.joins == null ? "<null>" : this.joins);
        sb.append(',');
        sb.append("sql");
        sb.append('=');
        sb.append(this.sql == null ? "<null>" : this.sql);
        sb.append(',');
        sb.append("dialect");
        sb.append('=');
        sb.append(this.dialect == null ? "<null>" : this.dialect);
        sb.append(',');
        sb.append("queryType");
        sb.append('=');
        sb.append(this.queryType == null ? "<null>" : this.queryType);
        sb.append(',');
        sb.append("excludeUsage");
        sb.append('=');
        sb.append(this.excludeUsage == null ? "<null>" : this.excludeUsage);
        sb.append(',');
        sb.append("serviceName");
        sb.append('=');
        sb.append(this.serviceName == null ? "<null>" : this.serviceName);
        sb.append(',');
        sb.append("userName");
        sb.append('=');
        sb.append(this.userName == null ? "<null>" : this.userName);
        sb.append(',');
        sb.append("date");
        sb.append('=');
        sb.append(this.date == null ? "<null>" : this.date);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.joins == null ? 0 : this.joins.hashCode());
        result = result * 31 + (this.date == null ? 0 : this.date.hashCode());
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.excludeUsage == null ? 0 : this.excludeUsage.hashCode());
        result = result * 31 + (this.dialect == null ? 0 : this.dialect.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = result * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 31 + (this.sql == null ? 0 : this.sql.hashCode());
        result = result * 31 + (this.queryType == null ? 0 : this.queryType.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.tables == null ? 0 : this.tables.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ParsedData)) {
            return false;
        }
        ParsedData rhs = (ParsedData)other;
        return (this.joins == rhs.joins || this.joins != null && this.joins.equals(rhs.joins)) && (this.date == rhs.date || this.date != null && this.date.equals(rhs.date)) && (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.excludeUsage == rhs.excludeUsage || this.excludeUsage != null && this.excludeUsage.equals(rhs.excludeUsage)) && (this.dialect == rhs.dialect || this.dialect != null && this.dialect.equals(rhs.dialect)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.serviceName == rhs.serviceName || this.serviceName != null && this.serviceName.equals(rhs.serviceName)) && (this.userName == rhs.userName || this.userName != null && this.userName.equals(rhs.userName)) && (this.sql == rhs.sql || this.sql != null && this.sql.equals(rhs.sql)) && (this.queryType == rhs.queryType || this.queryType != null && this.queryType.equals(rhs.queryType)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.tables == rhs.tables || this.tables != null && this.tables.equals(rhs.tables)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

