/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.type.PartitionIntervalTypes;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enablePartitioning", "partitionColumnName", "partitionIntervalType", "partitionInterval", "partitionIntervalUnit", "partitionValues", "partitionIntegerRangeStart", "partitionIntegerRangeEnd"})
public class PartitionProfilerConfig {
    @JsonProperty(value="enablePartitioning")
    @JsonPropertyDescription(value="whether to use partition")
    private Boolean enablePartitioning = false;
    @JsonProperty(value="partitionColumnName")
    @JsonPropertyDescription(value="name of the column to use for the partition")
    private String partitionColumnName;
    @JsonProperty(value="partitionIntervalType")
    @JsonPropertyDescription(value="type of partition interval")
    private PartitionIntervalTypes partitionIntervalType;
    @JsonProperty(value="partitionInterval")
    @JsonPropertyDescription(value="The interval to use for the partitioning")
    private Integer partitionInterval;
    @JsonProperty(value="partitionIntervalUnit")
    @JsonPropertyDescription(value="unit used for the partition interval")
    private PartitionIntervalUnit partitionIntervalUnit;
    @JsonProperty(value="partitionValues")
    @JsonPropertyDescription(value="unit used for the partition interval")
    @Valid
    private List<Object> partitionValues = new ArrayList<Object>();
    @JsonProperty(value="partitionIntegerRangeStart")
    @JsonPropertyDescription(value="start of the integer range for partitioning")
    private Integer partitionIntegerRangeStart = null;
    @JsonProperty(value="partitionIntegerRangeEnd")
    @JsonPropertyDescription(value="end of the integer range for partitioning")
    private Integer partitionIntegerRangeEnd = null;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="enablePartitioning")
    public Boolean getEnablePartitioning() {
        return this.enablePartitioning;
    }

    @JsonProperty(value="enablePartitioning")
    public void setEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
    }

    public PartitionProfilerConfig withEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    @JsonProperty(value="partitionColumnName")
    public String getPartitionColumnName() {
        return this.partitionColumnName;
    }

    @JsonProperty(value="partitionColumnName")
    public void setPartitionColumnName(String partitionColumnName) {
        this.partitionColumnName = partitionColumnName;
    }

    public PartitionProfilerConfig withPartitionColumnName(String partitionColumnName) {
        this.partitionColumnName = partitionColumnName;
        return this;
    }

    @JsonProperty(value="partitionIntervalType")
    public PartitionIntervalTypes getPartitionIntervalType() {
        return this.partitionIntervalType;
    }

    @JsonProperty(value="partitionIntervalType")
    public void setPartitionIntervalType(PartitionIntervalTypes partitionIntervalType) {
        this.partitionIntervalType = partitionIntervalType;
    }

    public PartitionProfilerConfig withPartitionIntervalType(PartitionIntervalTypes partitionIntervalType) {
        this.partitionIntervalType = partitionIntervalType;
        return this;
    }

    @JsonProperty(value="partitionInterval")
    public Integer getPartitionInterval() {
        return this.partitionInterval;
    }

    @JsonProperty(value="partitionInterval")
    public void setPartitionInterval(Integer partitionInterval) {
        this.partitionInterval = partitionInterval;
    }

    public PartitionProfilerConfig withPartitionInterval(Integer partitionInterval) {
        this.partitionInterval = partitionInterval;
        return this;
    }

    @JsonProperty(value="partitionIntervalUnit")
    public PartitionIntervalUnit getPartitionIntervalUnit() {
        return this.partitionIntervalUnit;
    }

    @JsonProperty(value="partitionIntervalUnit")
    public void setPartitionIntervalUnit(PartitionIntervalUnit partitionIntervalUnit) {
        this.partitionIntervalUnit = partitionIntervalUnit;
    }

    public PartitionProfilerConfig withPartitionIntervalUnit(PartitionIntervalUnit partitionIntervalUnit) {
        this.partitionIntervalUnit = partitionIntervalUnit;
        return this;
    }

    @JsonProperty(value="partitionValues")
    public List<Object> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty(value="partitionValues")
    public void setPartitionValues(List<Object> partitionValues) {
        this.partitionValues = partitionValues;
    }

    public PartitionProfilerConfig withPartitionValues(List<Object> partitionValues) {
        this.partitionValues = partitionValues;
        return this;
    }

    @JsonProperty(value="partitionIntegerRangeStart")
    public Integer getPartitionIntegerRangeStart() {
        return this.partitionIntegerRangeStart;
    }

    @JsonProperty(value="partitionIntegerRangeStart")
    public void setPartitionIntegerRangeStart(Integer partitionIntegerRangeStart) {
        this.partitionIntegerRangeStart = partitionIntegerRangeStart;
    }

    public PartitionProfilerConfig withPartitionIntegerRangeStart(Integer partitionIntegerRangeStart) {
        this.partitionIntegerRangeStart = partitionIntegerRangeStart;
        return this;
    }

    @JsonProperty(value="partitionIntegerRangeEnd")
    public Integer getPartitionIntegerRangeEnd() {
        return this.partitionIntegerRangeEnd;
    }

    @JsonProperty(value="partitionIntegerRangeEnd")
    public void setPartitionIntegerRangeEnd(Integer partitionIntegerRangeEnd) {
        this.partitionIntegerRangeEnd = partitionIntegerRangeEnd;
    }

    public PartitionProfilerConfig withPartitionIntegerRangeEnd(Integer partitionIntegerRangeEnd) {
        this.partitionIntegerRangeEnd = partitionIntegerRangeEnd;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public PartitionProfilerConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PartitionProfilerConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enablePartitioning");
        sb.append('=');
        sb.append(this.enablePartitioning == null ? "<null>" : this.enablePartitioning);
        sb.append(',');
        sb.append("partitionColumnName");
        sb.append('=');
        sb.append(this.partitionColumnName == null ? "<null>" : this.partitionColumnName);
        sb.append(',');
        sb.append("partitionIntervalType");
        sb.append('=');
        sb.append(this.partitionIntervalType == null ? "<null>" : this.partitionIntervalType);
        sb.append(',');
        sb.append("partitionInterval");
        sb.append('=');
        sb.append(this.partitionInterval == null ? "<null>" : this.partitionInterval);
        sb.append(',');
        sb.append("partitionIntervalUnit");
        sb.append('=');
        sb.append(this.partitionIntervalUnit == null ? "<null>" : this.partitionIntervalUnit);
        sb.append(',');
        sb.append("partitionValues");
        sb.append('=');
        sb.append(this.partitionValues == null ? "<null>" : this.partitionValues);
        sb.append(',');
        sb.append("partitionIntegerRangeStart");
        sb.append('=');
        sb.append(this.partitionIntegerRangeStart == null ? "<null>" : this.partitionIntegerRangeStart);
        sb.append(',');
        sb.append("partitionIntegerRangeEnd");
        sb.append('=');
        sb.append(this.partitionIntegerRangeEnd == null ? "<null>" : this.partitionIntegerRangeEnd);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.partitionInterval == null ? 0 : this.partitionInterval.hashCode());
        result = result * 31 + (this.partitionIntervalType == null ? 0 : this.partitionIntervalType.hashCode());
        result = result * 31 + (this.enablePartitioning == null ? 0 : this.enablePartitioning.hashCode());
        result = result * 31 + (this.partitionIntegerRangeStart == null ? 0 : this.partitionIntegerRangeStart.hashCode());
        result = result * 31 + (this.partitionIntervalUnit == null ? 0 : this.partitionIntervalUnit.hashCode());
        result = result * 31 + (this.partitionIntegerRangeEnd == null ? 0 : this.partitionIntegerRangeEnd.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.partitionValues == null ? 0 : this.partitionValues.hashCode());
        result = result * 31 + (this.partitionColumnName == null ? 0 : this.partitionColumnName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PartitionProfilerConfig)) {
            return false;
        }
        PartitionProfilerConfig rhs = (PartitionProfilerConfig)other;
        return (this.partitionInterval == rhs.partitionInterval || this.partitionInterval != null && this.partitionInterval.equals(rhs.partitionInterval)) && (this.partitionIntervalType == rhs.partitionIntervalType || this.partitionIntervalType != null && this.partitionIntervalType.equals((Object)rhs.partitionIntervalType)) && (this.enablePartitioning == rhs.enablePartitioning || this.enablePartitioning != null && this.enablePartitioning.equals(rhs.enablePartitioning)) && (this.partitionIntegerRangeStart == rhs.partitionIntegerRangeStart || this.partitionIntegerRangeStart != null && this.partitionIntegerRangeStart.equals(rhs.partitionIntegerRangeStart)) && (this.partitionIntervalUnit == rhs.partitionIntervalUnit || this.partitionIntervalUnit != null && this.partitionIntervalUnit.equals((Object)rhs.partitionIntervalUnit)) && (this.partitionIntegerRangeEnd == rhs.partitionIntegerRangeEnd || this.partitionIntegerRangeEnd != null && this.partitionIntegerRangeEnd.equals(rhs.partitionIntegerRangeEnd)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.partitionValues == rhs.partitionValues || this.partitionValues != null && this.partitionValues.equals(rhs.partitionValues)) && (this.partitionColumnName == rhs.partitionColumnName || this.partitionColumnName != null && this.partitionColumnName.equals(rhs.partitionColumnName));
    }

    public static enum PartitionIntervalUnit {
        YEAR("YEAR"),
        MONTH("MONTH"),
        DAY("DAY"),
        HOUR("HOUR");

        private final String value;
        private static final Map<String, PartitionIntervalUnit> CONSTANTS;

        private PartitionIntervalUnit(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PartitionIntervalUnit fromValue(String value) {
            PartitionIntervalUnit constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PartitionIntervalUnit>();
            for (PartitionIntervalUnit c : PartitionIntervalUnit.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

