/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ProviderType {
    SYSTEM("system"),
    USER("user");

    private final String value;
    private static final Map<String, ProviderType> CONSTANTS;

    private ProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ProviderType fromValue(String value) {
        ProviderType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ProviderType>();
        for (ProviderType c : ProviderType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

