/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ReactionType {
    THUMBS_UP("thumbsUp"),
    THUMBS_DOWN("thumbsDown"),
    HOORAY("hooray"),
    LAUGH("laugh"),
    CONFUSED("confused"),
    HEART("heart"),
    ROCKET("rocket"),
    EYES("eyes");

    private final String value;
    private static final Map<String, ReactionType> CONSTANTS;

    private ReactionType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ReactionType fromValue(String value) {
        ReactionType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ReactionType>();
        for (ReactionType c : ReactionType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

