/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Permission;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"resource", "permissions"})
public class ResourcePermission {
    @JsonProperty(value="resource")
    @JsonPropertyDescription(value="Name of the resource")
    @NotNull
    private String resource;
    @JsonProperty(value="permissions")
    @JsonPropertyDescription(value="Permissions for a `resource`.")
    @Valid
    @NotNull
    private List<Permission> permissions = new ArrayList<Permission>();

    @JsonProperty(value="resource")
    public String getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    public void setResource(String resource) {
        this.resource = resource;
    }

    public ResourcePermission withResource(String resource) {
        this.resource = resource;
        return this;
    }

    @JsonProperty(value="permissions")
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public ResourcePermission withPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ResourcePermission.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("resource");
        sb.append('=');
        sb.append(this.resource == null ? "<null>" : this.resource);
        sb.append(',');
        sb.append("permissions");
        sb.append('=');
        sb.append(this.permissions == null ? "<null>" : this.permissions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.resource == null ? 0 : this.resource.hashCode());
        result = result * 31 + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResourcePermission)) {
            return false;
        }
        ResourcePermission rhs = (ResourcePermission)other;
        return (this.resource == rhs.resource || this.resource != null && this.resource.equals(rhs.resource)) && (this.permissions == rhs.permissions || this.permissions != null && this.permissions.equals(rhs.permissions));
    }
}

