/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openmetadata.schema.FieldInterface;
import org.openmetadata.schema.type.SearchIndexDataType;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "dataType", "dataTypeDisplay", "description", "fullyQualifiedName", "tags", "children"})
public class SearchIndexField
implements FieldInterface {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Local name (not fully qualified name) of the field. ")
    @Pattern(regexp="^((?!::).)*$")
    @Size(min=1, max=256)
    @NotNull
    private @Pattern(regexp="^((?!::).)*$") @Size(min=1, max=256) @NotNull String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this searchIndexField name.")
    private String displayName;
    @JsonProperty(value="dataType")
    @JsonPropertyDescription(value="This enum defines the type of data stored in a searchIndex.")
    @NotNull
    private SearchIndexDataType dataType;
    @JsonProperty(value="dataTypeDisplay")
    @JsonPropertyDescription(value="Display name used for dataType. ")
    private String dataTypeDisplay;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.")
    @Size(min=1, max=3072)
    private @Size(min=1, max=3072) String fullyQualifiedName;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags associated with the column.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="children")
    @JsonPropertyDescription(value="Child columns if dataType has properties.")
    @Valid
    private List<SearchIndexField> children = null;

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public SearchIndexField withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public SearchIndexField withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="dataType")
    public SearchIndexDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(SearchIndexDataType dataType) {
        this.dataType = dataType;
    }

    public SearchIndexField withDataType(SearchIndexDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    @JsonProperty(value="dataTypeDisplay")
    public String getDataTypeDisplay() {
        return this.dataTypeDisplay;
    }

    @JsonProperty(value="dataTypeDisplay")
    public void setDataTypeDisplay(String dataTypeDisplay) {
        this.dataTypeDisplay = dataTypeDisplay;
    }

    public SearchIndexField withDataTypeDisplay(String dataTypeDisplay) {
        this.dataTypeDisplay = dataTypeDisplay;
        return this;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public SearchIndexField withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public SearchIndexField withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Override
    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public SearchIndexField withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="children")
    public List<SearchIndexField> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    public void setChildren(List<SearchIndexField> children) {
        this.children = children;
    }

    public SearchIndexField withChildren(List<SearchIndexField> children) {
        this.children = children;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SearchIndexField.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("dataTypeDisplay");
        sb.append('=');
        sb.append(this.dataTypeDisplay == null ? "<null>" : this.dataTypeDisplay);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("children");
        sb.append('=');
        sb.append(this.children == null ? "<null>" : this.children);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.children == null ? 0 : this.children.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.dataTypeDisplay == null ? 0 : this.dataTypeDisplay.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SearchIndexField)) {
            return false;
        }
        SearchIndexField rhs = (SearchIndexField)other;
        return (this.children == rhs.children || this.children != null && this.children.equals(rhs.children)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.dataTypeDisplay == rhs.dataTypeDisplay || this.dataTypeDisplay != null && this.dataTypeDisplay.equals(rhs.dataTypeDisplay)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags));
    }
}

