/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum StatusType {
    Successful("Successful"),
    Failed("Failed"),
    Pending("Pending"),
    Skipped("Skipped");

    private final String value;
    private static final Map<String, StatusType> CONSTANTS;

    private StatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static StatusType fromValue(String value) {
        StatusType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, StatusType>();
        for (StatusType c : StatusType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

