/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"constraintType", "columns", "referredColumns"})
public class TableConstraint {
    @JsonProperty(value="constraintType")
    private ConstraintType constraintType;
    @JsonProperty(value="columns")
    @JsonPropertyDescription(value="List of column names corresponding to the constraint.")
    @Valid
    private List<String> columns = new ArrayList<String>();
    @JsonProperty(value="referredColumns")
    @JsonPropertyDescription(value="List of referred columns for the constraint.")
    @Valid
    private List<String> referredColumns = null;

    @JsonProperty(value="constraintType")
    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    @JsonProperty(value="constraintType")
    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public TableConstraint withConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
        return this;
    }

    @JsonProperty(value="columns")
    public List<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public TableConstraint withColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="referredColumns")
    public List<String> getReferredColumns() {
        return this.referredColumns;
    }

    @JsonProperty(value="referredColumns")
    public void setReferredColumns(List<String> referredColumns) {
        this.referredColumns = referredColumns;
    }

    public TableConstraint withReferredColumns(List<String> referredColumns) {
        this.referredColumns = referredColumns;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableConstraint.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("constraintType");
        sb.append('=');
        sb.append(this.constraintType == null ? "<null>" : this.constraintType);
        sb.append(',');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("referredColumns");
        sb.append('=');
        sb.append(this.referredColumns == null ? "<null>" : this.referredColumns);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.constraintType == null ? 0 : this.constraintType.hashCode());
        result = result * 31 + (this.referredColumns == null ? 0 : this.referredColumns.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableConstraint)) {
            return false;
        }
        TableConstraint rhs = (TableConstraint)other;
        return (this.constraintType == rhs.constraintType || this.constraintType != null && this.constraintType.equals((Object)rhs.constraintType)) && (this.referredColumns == rhs.referredColumns || this.referredColumns != null && this.referredColumns.equals(rhs.referredColumns)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns));
    }

    public static enum ConstraintType {
        UNIQUE("UNIQUE"),
        PRIMARY_KEY("PRIMARY_KEY"),
        FOREIGN_KEY("FOREIGN_KEY"),
        SORT_KEY("SORT_KEY"),
        DIST_KEY("DIST_KEY");

        private final String value;
        private static final Map<String, ConstraintType> CONSTANTS;

        private ConstraintType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ConstraintType fromValue(String value) {
            ConstraintType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ConstraintType>();
            for (ConstraintType c : ConstraintType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

