/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.CustomMetricProfile;
import org.openmetadata.schema.type.TableProfilerConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"timestamp", "profileSample", "profileSampleType", "columnCount", "rowCount", "sizeInByte", "createDateTime", "customMetrics"})
public class TableProfile {
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp in Unix epoch time milliseconds.")
    @NotNull
    private Long timestamp;
    @JsonProperty(value="profileSample")
    @JsonPropertyDescription(value="Percentage of data or no. of rows we want to execute the profiler and tests on")
    private Double profileSample = null;
    @JsonProperty(value="profileSampleType")
    @JsonPropertyDescription(value="Type of Profile Sample (percentage or rows)")
    private TableProfilerConfig.ProfileSampleType profileSampleType = TableProfilerConfig.ProfileSampleType.fromValue("PERCENTAGE");
    @JsonProperty(value="columnCount")
    @JsonPropertyDescription(value="No.of columns in the table.")
    private Double columnCount;
    @JsonProperty(value="rowCount")
    @JsonPropertyDescription(value="No.of rows in the table. This is always executed on the whole table.")
    private Double rowCount;
    @JsonProperty(value="sizeInByte")
    @JsonPropertyDescription(value="Table size in GB")
    private Double sizeInByte;
    @JsonProperty(value="createDateTime")
    @JsonPropertyDescription(value="Table creation time.")
    private Date createDateTime;
    @JsonProperty(value="customMetrics")
    @JsonPropertyDescription(value="Custom Metrics profile list bound to a column.")
    @Valid
    private List<CustomMetricProfile> customMetrics = null;

    @JsonProperty(value="timestamp")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public TableProfile withTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="profileSample")
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public TableProfile withProfileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @JsonProperty(value="profileSampleType")
    public TableProfilerConfig.ProfileSampleType getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    public void setProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public TableProfile withProfileSampleType(TableProfilerConfig.ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @JsonProperty(value="columnCount")
    public Double getColumnCount() {
        return this.columnCount;
    }

    @JsonProperty(value="columnCount")
    public void setColumnCount(Double columnCount) {
        this.columnCount = columnCount;
    }

    public TableProfile withColumnCount(Double columnCount) {
        this.columnCount = columnCount;
        return this;
    }

    @JsonProperty(value="rowCount")
    public Double getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="rowCount")
    public void setRowCount(Double rowCount) {
        this.rowCount = rowCount;
    }

    public TableProfile withRowCount(Double rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    @JsonProperty(value="sizeInByte")
    public Double getSizeInByte() {
        return this.sizeInByte;
    }

    @JsonProperty(value="sizeInByte")
    public void setSizeInByte(Double sizeInByte) {
        this.sizeInByte = sizeInByte;
    }

    public TableProfile withSizeInByte(Double sizeInByte) {
        this.sizeInByte = sizeInByte;
        return this;
    }

    @JsonProperty(value="createDateTime")
    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    @JsonProperty(value="createDateTime")
    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public TableProfile withCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
        return this;
    }

    @JsonProperty(value="customMetrics")
    public List<CustomMetricProfile> getCustomMetrics() {
        return this.customMetrics;
    }

    @JsonProperty(value="customMetrics")
    public void setCustomMetrics(List<CustomMetricProfile> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public TableProfile withCustomMetrics(List<CustomMetricProfile> customMetrics) {
        this.customMetrics = customMetrics;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableProfile.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("profileSample");
        sb.append('=');
        sb.append(this.profileSample == null ? "<null>" : this.profileSample);
        sb.append(',');
        sb.append("profileSampleType");
        sb.append('=');
        sb.append(this.profileSampleType == null ? "<null>" : this.profileSampleType);
        sb.append(',');
        sb.append("columnCount");
        sb.append('=');
        sb.append(this.columnCount == null ? "<null>" : this.columnCount);
        sb.append(',');
        sb.append("rowCount");
        sb.append('=');
        sb.append(this.rowCount == null ? "<null>" : this.rowCount);
        sb.append(',');
        sb.append("sizeInByte");
        sb.append('=');
        sb.append(this.sizeInByte == null ? "<null>" : this.sizeInByte);
        sb.append(',');
        sb.append("createDateTime");
        sb.append('=');
        sb.append(this.createDateTime == null ? "<null>" : this.createDateTime);
        sb.append(',');
        sb.append("customMetrics");
        sb.append('=');
        sb.append(this.customMetrics == null ? "<null>" : this.customMetrics);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.profileSampleType == null ? 0 : this.profileSampleType.hashCode());
        result = result * 31 + (this.columnCount == null ? 0 : this.columnCount.hashCode());
        result = result * 31 + (this.rowCount == null ? 0 : this.rowCount.hashCode());
        result = result * 31 + (this.sizeInByte == null ? 0 : this.sizeInByte.hashCode());
        result = result * 31 + (this.profileSample == null ? 0 : this.profileSample.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = result * 31 + (this.createDateTime == null ? 0 : this.createDateTime.hashCode());
        result = result * 31 + (this.customMetrics == null ? 0 : this.customMetrics.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableProfile)) {
            return false;
        }
        TableProfile rhs = (TableProfile)other;
        return (this.profileSampleType == rhs.profileSampleType || this.profileSampleType != null && this.profileSampleType.equals((Object)rhs.profileSampleType)) && (this.columnCount == rhs.columnCount || this.columnCount != null && this.columnCount.equals(rhs.columnCount)) && (this.rowCount == rhs.rowCount || this.rowCount != null && this.rowCount.equals(rhs.rowCount)) && (this.sizeInByte == rhs.sizeInByte || this.sizeInByte != null && this.sizeInByte.equals(rhs.sizeInByte)) && (this.profileSample == rhs.profileSample || this.profileSample != null && this.profileSample.equals(rhs.profileSample)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp)) && (this.createDateTime == rhs.createDateTime || this.createDateTime != null && this.createDateTime.equals(rhs.createDateTime)) && (this.customMetrics == rhs.customMetrics || this.customMetrics != null && this.customMetrics.equals(rhs.customMetrics));
    }
}

