/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.openmetadata.schema.type.ColumnProfilerConfig;
import org.openmetadata.schema.type.PartitionProfilerConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"profileSampleType", "profileSample", "sampleDataCount", "profileQuery", "excludeColumns", "includeColumns", "partitioning"})
public class TableProfilerConfig {
    @JsonProperty(value="profileSampleType")
    @JsonPropertyDescription(value="Type of Profile Sample (percentage or rows)")
    private ProfileSampleType profileSampleType = ProfileSampleType.fromValue("PERCENTAGE");
    @JsonProperty(value="profileSample")
    @JsonPropertyDescription(value="Percentage of data or no. of rows used to compute the profiler metrics and run data quality tests")
    private Double profileSample = null;
    @JsonProperty(value="sampleDataCount")
    @JsonPropertyDescription(value="Number of sample rows to ingest when 'Generate Sample Data' is enabled")
    private Integer sampleDataCount = 50;
    @JsonProperty(value="profileQuery")
    @JsonPropertyDescription(value="Users' raw SQL query to fetch sample data and profile the table")
    private String profileQuery = null;
    @JsonProperty(value="excludeColumns")
    @JsonPropertyDescription(value="column names to exclude from profiling.")
    @Valid
    private List<String> excludeColumns = null;
    @JsonProperty(value="includeColumns")
    @JsonPropertyDescription(value="Only run profiler on included columns with specific metrics.")
    @Valid
    private List<ColumnProfilerConfig> includeColumns = null;
    @JsonProperty(value="partitioning")
    @JsonPropertyDescription(value="This schema defines the partition configuration used by profiler.")
    @Valid
    private PartitionProfilerConfig partitioning;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @JsonProperty(value="profileSampleType")
    public ProfileSampleType getProfileSampleType() {
        return this.profileSampleType;
    }

    @JsonProperty(value="profileSampleType")
    public void setProfileSampleType(ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
    }

    public TableProfilerConfig withProfileSampleType(ProfileSampleType profileSampleType) {
        this.profileSampleType = profileSampleType;
        return this;
    }

    @JsonProperty(value="profileSample")
    public Double getProfileSample() {
        return this.profileSample;
    }

    @JsonProperty(value="profileSample")
    public void setProfileSample(Double profileSample) {
        this.profileSample = profileSample;
    }

    public TableProfilerConfig withProfileSample(Double profileSample) {
        this.profileSample = profileSample;
        return this;
    }

    @JsonProperty(value="sampleDataCount")
    public Integer getSampleDataCount() {
        return this.sampleDataCount;
    }

    @JsonProperty(value="sampleDataCount")
    public void setSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
    }

    public TableProfilerConfig withSampleDataCount(Integer sampleDataCount) {
        this.sampleDataCount = sampleDataCount;
        return this;
    }

    @JsonProperty(value="profileQuery")
    public String getProfileQuery() {
        return this.profileQuery;
    }

    @JsonProperty(value="profileQuery")
    public void setProfileQuery(String profileQuery) {
        this.profileQuery = profileQuery;
    }

    public TableProfilerConfig withProfileQuery(String profileQuery) {
        this.profileQuery = profileQuery;
        return this;
    }

    @JsonProperty(value="excludeColumns")
    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    @JsonProperty(value="excludeColumns")
    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public TableProfilerConfig withExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
        return this;
    }

    @JsonProperty(value="includeColumns")
    public List<ColumnProfilerConfig> getIncludeColumns() {
        return this.includeColumns;
    }

    @JsonProperty(value="includeColumns")
    public void setIncludeColumns(List<ColumnProfilerConfig> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public TableProfilerConfig withIncludeColumns(List<ColumnProfilerConfig> includeColumns) {
        this.includeColumns = includeColumns;
        return this;
    }

    @JsonProperty(value="partitioning")
    public PartitionProfilerConfig getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty(value="partitioning")
    public void setPartitioning(PartitionProfilerConfig partitioning) {
        this.partitioning = partitioning;
    }

    public TableProfilerConfig withPartitioning(PartitionProfilerConfig partitioning) {
        this.partitioning = partitioning;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TableProfilerConfig withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableProfilerConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("profileSampleType");
        sb.append('=');
        sb.append(this.profileSampleType == null ? "<null>" : this.profileSampleType);
        sb.append(',');
        sb.append("profileSample");
        sb.append('=');
        sb.append(this.profileSample == null ? "<null>" : this.profileSample);
        sb.append(',');
        sb.append("sampleDataCount");
        sb.append('=');
        sb.append(this.sampleDataCount == null ? "<null>" : this.sampleDataCount);
        sb.append(',');
        sb.append("profileQuery");
        sb.append('=');
        sb.append(this.profileQuery == null ? "<null>" : this.profileQuery);
        sb.append(',');
        sb.append("excludeColumns");
        sb.append('=');
        sb.append(this.excludeColumns == null ? "<null>" : this.excludeColumns);
        sb.append(',');
        sb.append("includeColumns");
        sb.append('=');
        sb.append(this.includeColumns == null ? "<null>" : this.includeColumns);
        sb.append(',');
        sb.append("partitioning");
        sb.append('=');
        sb.append(this.partitioning == null ? "<null>" : this.partitioning);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.profileQuery == null ? 0 : this.profileQuery.hashCode());
        result = result * 31 + (this.excludeColumns == null ? 0 : this.excludeColumns.hashCode());
        result = result * 31 + (this.sampleDataCount == null ? 0 : this.sampleDataCount.hashCode());
        result = result * 31 + (this.profileSampleType == null ? 0 : this.profileSampleType.hashCode());
        result = result * 31 + (this.partitioning == null ? 0 : this.partitioning.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.includeColumns == null ? 0 : this.includeColumns.hashCode());
        result = result * 31 + (this.profileSample == null ? 0 : this.profileSample.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableProfilerConfig)) {
            return false;
        }
        TableProfilerConfig rhs = (TableProfilerConfig)other;
        return (this.profileQuery == rhs.profileQuery || this.profileQuery != null && this.profileQuery.equals(rhs.profileQuery)) && (this.excludeColumns == rhs.excludeColumns || this.excludeColumns != null && this.excludeColumns.equals(rhs.excludeColumns)) && (this.sampleDataCount == rhs.sampleDataCount || this.sampleDataCount != null && this.sampleDataCount.equals(rhs.sampleDataCount)) && (this.profileSampleType == rhs.profileSampleType || this.profileSampleType != null && this.profileSampleType.equals((Object)rhs.profileSampleType)) && (this.partitioning == rhs.partitioning || this.partitioning != null && this.partitioning.equals(rhs.partitioning)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.includeColumns == rhs.includeColumns || this.includeColumns != null && this.includeColumns.equals(rhs.includeColumns)) && (this.profileSample == rhs.profileSample || this.profileSample != null && this.profileSample.equals(rhs.profileSample));
    }

    public static enum ProfileSampleType {
        PERCENTAGE("PERCENTAGE"),
        ROWS("ROWS");

        private final String value;
        private static final Map<String, ProfileSampleType> CONSTANTS;

        private ProfileSampleType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProfileSampleType fromValue(String value) {
            ProfileSampleType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ProfileSampleType>();
            for (ProfileSampleType c : ProfileSampleType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

