/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.api.data.CreateQuery;
import org.openmetadata.schema.type.TableColumnJoin;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"table", "date", "databaseName", "count", "databaseSchema", "sqlQueries", "joins", "serviceName"})
public class TableUsageCount {
    @JsonProperty(value="table")
    @JsonPropertyDescription(value="Name of the table")
    @NotNull
    private String table;
    @JsonProperty(value="date")
    @JsonPropertyDescription(value="Date of execution of SQL query")
    @NotNull
    private String date;
    @JsonProperty(value="databaseName")
    @JsonPropertyDescription(value="Database associated with the table in the query")
    private String databaseName;
    @JsonProperty(value="count")
    @JsonPropertyDescription(value="Usage count of table")
    private Integer count = 1;
    @JsonProperty(value="databaseSchema")
    @JsonPropertyDescription(value="Database schema of the associated with table")
    private String databaseSchema;
    @JsonProperty(value="sqlQueries")
    @JsonPropertyDescription(value="List of SQL Queries associated with table")
    @Valid
    private List<CreateQuery> sqlQueries = new ArrayList<CreateQuery>();
    @JsonProperty(value="joins")
    @JsonPropertyDescription(value="List of joins associated with table")
    @Valid
    private List<TableColumnJoin> joins = new ArrayList<TableColumnJoin>();
    @JsonProperty(value="serviceName")
    @JsonPropertyDescription(value="Name that identifies this database service.")
    @NotNull
    private String serviceName;

    @JsonProperty(value="table")
    public String getTable() {
        return this.table;
    }

    @JsonProperty(value="table")
    public void setTable(String table) {
        this.table = table;
    }

    public TableUsageCount withTable(String table) {
        this.table = table;
        return this;
    }

    @JsonProperty(value="date")
    public String getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    public void setDate(String date) {
        this.date = date;
    }

    public TableUsageCount withDate(String date) {
        this.date = date;
        return this;
    }

    @JsonProperty(value="databaseName")
    public String getDatabaseName() {
        return this.databaseName;
    }

    @JsonProperty(value="databaseName")
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public TableUsageCount withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    @JsonProperty(value="count")
    public void setCount(Integer count) {
        this.count = count;
    }

    public TableUsageCount withCount(Integer count) {
        this.count = count;
        return this;
    }

    @JsonProperty(value="databaseSchema")
    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    @JsonProperty(value="databaseSchema")
    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public TableUsageCount withDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    @JsonProperty(value="sqlQueries")
    public List<CreateQuery> getSqlQueries() {
        return this.sqlQueries;
    }

    @JsonProperty(value="sqlQueries")
    public void setSqlQueries(List<CreateQuery> sqlQueries) {
        this.sqlQueries = sqlQueries;
    }

    public TableUsageCount withSqlQueries(List<CreateQuery> sqlQueries) {
        this.sqlQueries = sqlQueries;
        return this;
    }

    @JsonProperty(value="joins")
    public List<TableColumnJoin> getJoins() {
        return this.joins;
    }

    @JsonProperty(value="joins")
    public void setJoins(List<TableColumnJoin> joins) {
        this.joins = joins;
    }

    public TableUsageCount withJoins(List<TableColumnJoin> joins) {
        this.joins = joins;
        return this;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public TableUsageCount withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableUsageCount.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("table");
        sb.append('=');
        sb.append(this.table == null ? "<null>" : this.table);
        sb.append(',');
        sb.append("date");
        sb.append('=');
        sb.append(this.date == null ? "<null>" : this.date);
        sb.append(',');
        sb.append("databaseName");
        sb.append('=');
        sb.append(this.databaseName == null ? "<null>" : this.databaseName);
        sb.append(',');
        sb.append("count");
        sb.append('=');
        sb.append(this.count == null ? "<null>" : this.count);
        sb.append(',');
        sb.append("databaseSchema");
        sb.append('=');
        sb.append(this.databaseSchema == null ? "<null>" : this.databaseSchema);
        sb.append(',');
        sb.append("sqlQueries");
        sb.append('=');
        sb.append(this.sqlQueries == null ? "<null>" : this.sqlQueries);
        sb.append(',');
        sb.append("joins");
        sb.append('=');
        sb.append(this.joins == null ? "<null>" : this.joins);
        sb.append(',');
        sb.append("serviceName");
        sb.append('=');
        sb.append(this.serviceName == null ? "<null>" : this.serviceName);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.date == null ? 0 : this.date.hashCode());
        result = result * 31 + (this.databaseSchema == null ? 0 : this.databaseSchema.hashCode());
        result = result * 31 + (this.joins == null ? 0 : this.joins.hashCode());
        result = result * 31 + (this.databaseName == null ? 0 : this.databaseName.hashCode());
        result = result * 31 + (this.count == null ? 0 : this.count.hashCode());
        result = result * 31 + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = result * 31 + (this.table == null ? 0 : this.table.hashCode());
        result = result * 31 + (this.sqlQueries == null ? 0 : this.sqlQueries.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableUsageCount)) {
            return false;
        }
        TableUsageCount rhs = (TableUsageCount)other;
        return (this.date == rhs.date || this.date != null && this.date.equals(rhs.date)) && (this.databaseSchema == rhs.databaseSchema || this.databaseSchema != null && this.databaseSchema.equals(rhs.databaseSchema)) && (this.joins == rhs.joins || this.joins != null && this.joins.equals(rhs.joins)) && (this.databaseName == rhs.databaseName || this.databaseName != null && this.databaseName.equals(rhs.databaseName)) && (this.count == rhs.count || this.count != null && this.count.equals(rhs.count)) && (this.serviceName == rhs.serviceName || this.serviceName != null && this.serviceName.equals(rhs.serviceName)) && (this.table == rhs.table || this.table != null && this.table.equals(rhs.table)) && (this.sqlQueries == rhs.sqlQueries || this.sqlQueries != null && this.sqlQueries.equals(rhs.sqlQueries));
    }
}

