/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.TagLabel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "displayName", "fullyQualifiedName", "description", "sourceUrl", "downstreamTasks", "taskType", "taskSQL", "startDate", "endDate", "tags", "owners"})
public class Task {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name that identifies this task instance uniquely.")
    @NotNull
    private String name;
    @JsonProperty(value="displayName")
    @JsonPropertyDescription(value="Display Name that identifies this Task. It could be title or label from the pipeline services.")
    private String displayName;
    @JsonProperty(value="fullyQualifiedName")
    @JsonPropertyDescription(value="A unique name that identifies a pipeline in the format 'ServiceName.PipelineName.TaskName'.")
    private String fullyQualifiedName;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Text in Markdown format.")
    private String description;
    @JsonProperty(value="sourceUrl")
    @JsonPropertyDescription(value="Source Url of the respective entity.")
    private String sourceUrl;
    @JsonProperty(value="downstreamTasks")
    @JsonPropertyDescription(value="All the tasks that are downstream of this task.")
    @Valid
    private List<String> downstreamTasks = null;
    @JsonProperty(value="taskType")
    @JsonPropertyDescription(value="Type of the Task. Usually refers to the class it implements.")
    private String taskType;
    @JsonProperty(value="taskSQL")
    @JsonPropertyDescription(value="SQL query statement. Example - 'select * from orders'.")
    private String taskSQL;
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="start date for the task.")
    private String startDate;
    @JsonProperty(value="endDate")
    @JsonPropertyDescription(value="end date for the task.")
    private String endDate;
    @JsonProperty(value="tags")
    @JsonPropertyDescription(value="Tags for this task.")
    @Valid
    private List<TagLabel> tags = null;
    @JsonProperty(value="owners")
    @JsonPropertyDescription(value="This schema defines the EntityReferenceList type used for referencing an entity. EntityReference is used for capturing relationships from one entity to another. For example, a table has an attribute called database of type EntityReference that captures the relationship of a table `belongs to a` database.")
    @Valid
    private List<EntityReference> owners = null;

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Task withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Task withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty(value="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public Task withFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Task withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="sourceUrl")
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public Task withSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @JsonProperty(value="downstreamTasks")
    public List<String> getDownstreamTasks() {
        return this.downstreamTasks;
    }

    @JsonProperty(value="downstreamTasks")
    public void setDownstreamTasks(List<String> downstreamTasks) {
        this.downstreamTasks = downstreamTasks;
    }

    public Task withDownstreamTasks(List<String> downstreamTasks) {
        this.downstreamTasks = downstreamTasks;
        return this;
    }

    @JsonProperty(value="taskType")
    public String getTaskType() {
        return this.taskType;
    }

    @JsonProperty(value="taskType")
    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Task withTaskType(String taskType) {
        this.taskType = taskType;
        return this;
    }

    @JsonProperty(value="taskSQL")
    public String getTaskSQL() {
        return this.taskSQL;
    }

    @JsonProperty(value="taskSQL")
    public void setTaskSQL(String taskSQL) {
        this.taskSQL = taskSQL;
    }

    public Task withTaskSQL(String taskSQL) {
        this.taskSQL = taskSQL;
        return this;
    }

    @JsonProperty(value="startDate")
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public Task withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="endDate")
    public String getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Task withEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @JsonProperty(value="tags")
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public Task withTags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    @JsonProperty(value="owners")
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public Task withOwners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Task.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(this.displayName == null ? "<null>" : this.displayName);
        sb.append(',');
        sb.append("fullyQualifiedName");
        sb.append('=');
        sb.append(this.fullyQualifiedName == null ? "<null>" : this.fullyQualifiedName);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(this.sourceUrl == null ? "<null>" : this.sourceUrl);
        sb.append(',');
        sb.append("downstreamTasks");
        sb.append('=');
        sb.append(this.downstreamTasks == null ? "<null>" : this.downstreamTasks);
        sb.append(',');
        sb.append("taskType");
        sb.append('=');
        sb.append(this.taskType == null ? "<null>" : this.taskType);
        sb.append(',');
        sb.append("taskSQL");
        sb.append('=');
        sb.append(this.taskSQL == null ? "<null>" : this.taskSQL);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(this.tags == null ? "<null>" : this.tags);
        sb.append(',');
        sb.append("owners");
        sb.append('=');
        sb.append(this.owners == null ? "<null>" : this.owners);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.owners == null ? 0 : this.owners.hashCode());
        result = result * 31 + (this.fullyQualifiedName == null ? 0 : this.fullyQualifiedName.hashCode());
        result = result * 31 + (this.tags == null ? 0 : this.tags.hashCode());
        result = result * 31 + (this.sourceUrl == null ? 0 : this.sourceUrl.hashCode());
        result = result * 31 + (this.taskType == null ? 0 : this.taskType.hashCode());
        result = result * 31 + (this.downstreamTasks == null ? 0 : this.downstreamTasks.hashCode());
        result = result * 31 + (this.taskSQL == null ? 0 : this.taskSQL.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Task)) {
            return false;
        }
        Task rhs = (Task)other;
        return (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.displayName == rhs.displayName || this.displayName != null && this.displayName.equals(rhs.displayName)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.owners == rhs.owners || this.owners != null && this.owners.equals(rhs.owners)) && (this.fullyQualifiedName == rhs.fullyQualifiedName || this.fullyQualifiedName != null && this.fullyQualifiedName.equals(rhs.fullyQualifiedName)) && (this.tags == rhs.tags || this.tags != null && this.tags.equals(rhs.tags)) && (this.sourceUrl == rhs.sourceUrl || this.sourceUrl != null && this.sourceUrl.equals(rhs.sourceUrl)) && (this.taskType == rhs.taskType || this.taskType != null && this.taskType.equals(rhs.taskType)) && (this.downstreamTasks == rhs.downstreamTasks || this.downstreamTasks != null && this.downstreamTasks.equals(rhs.downstreamTasks)) && (this.taskSQL == rhs.taskSQL || this.taskSQL != null && this.taskSQL.equals(rhs.taskSQL)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }
}

