/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum TaskType {
    RequestDescription("RequestDescription"),
    UpdateDescription("UpdateDescription"),
    RequestTag("RequestTag"),
    UpdateTag("UpdateTag"),
    RequestApproval("RequestApproval"),
    RequestTestCaseFailureResolution("RequestTestCaseFailureResolution"),
    Generic("Generic");

    private final String value;
    private static final Map<String, TaskType> CONSTANTS;

    private TaskType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static TaskType fromValue(String value) {
        TaskType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, TaskType>();
        for (TaskType c : TaskType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

