/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"count", "percentileRank"})
public class UsageStats {
    @JsonProperty(value="count")
    @JsonPropertyDescription(value="Usage count of a data asset on the start date.")
    @DecimalMin(value="0")
    @NotNull
    private @DecimalMin(value="0") @NotNull Integer count;
    @JsonProperty(value="percentileRank")
    @JsonPropertyDescription(value="Optional daily percentile rank data asset use when relevant.")
    private Double percentileRank;

    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    @JsonProperty(value="count")
    public void setCount(Integer count) {
        this.count = count;
    }

    public UsageStats withCount(Integer count) {
        this.count = count;
        return this;
    }

    @JsonProperty(value="percentileRank")
    public Double getPercentileRank() {
        return this.percentileRank;
    }

    @JsonProperty(value="percentileRank")
    public void setPercentileRank(Double percentileRank) {
        this.percentileRank = percentileRank;
    }

    public UsageStats withPercentileRank(Double percentileRank) {
        this.percentileRank = percentileRank;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UsageStats.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("count");
        sb.append('=');
        sb.append(this.count == null ? "<null>" : this.count);
        sb.append(',');
        sb.append("percentileRank");
        sb.append('=');
        sb.append(this.percentileRank == null ? "<null>" : this.percentileRank);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.count == null ? 0 : this.count.hashCode());
        result = result * 31 + (this.percentileRank == null ? 0 : this.percentileRank.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UsageStats)) {
            return false;
        }
        UsageStats rhs = (UsageStats)other;
        return (this.count == rhs.count || this.count != null && this.count.equals(rhs.count)) && (this.percentileRank == rhs.percentileRank || this.percentileRank != null && this.percentileRank.equals(rhs.percentileRank));
    }
}

