/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import org.openmetadata.schema.SubscriptionAction;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"receivers", "endpoint", "secretKey", "sendToAdmins", "sendToOwners", "sendToFollowers"})
public class Webhook
implements SubscriptionAction {
    @JsonProperty(value="receivers")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of receivers to send mail to")
    @Valid
    private Set<String> receivers = new LinkedHashSet<String>();
    @JsonProperty(value="endpoint")
    @JsonPropertyDescription(value="Endpoint to receive the webhook events over POST requests.")
    private URI endpoint;
    @JsonProperty(value="secretKey")
    @JsonPropertyDescription(value="Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.")
    private String secretKey;
    @JsonProperty(value="sendToAdmins")
    @JsonPropertyDescription(value="Send the Event to Admins")
    private Boolean sendToAdmins = false;
    @JsonProperty(value="sendToOwners")
    @JsonPropertyDescription(value="Send the Event to Owners")
    private Boolean sendToOwners = false;
    @JsonProperty(value="sendToFollowers")
    @JsonPropertyDescription(value="Send the Event to Followers")
    private Boolean sendToFollowers = false;

    @Override
    @JsonProperty(value="receivers")
    public Set<String> getReceivers() {
        return this.receivers;
    }

    @JsonProperty(value="receivers")
    public void setReceivers(Set<String> receivers) {
        this.receivers = receivers;
    }

    public Webhook withReceivers(Set<String> receivers) {
        this.receivers = receivers;
        return this;
    }

    @JsonProperty(value="endpoint")
    public URI getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public Webhook withEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty(value="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Webhook withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Override
    @JsonProperty(value="sendToAdmins")
    public Boolean getSendToAdmins() {
        return this.sendToAdmins;
    }

    @JsonProperty(value="sendToAdmins")
    public void setSendToAdmins(Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
    }

    public Webhook withSendToAdmins(Boolean sendToAdmins) {
        this.sendToAdmins = sendToAdmins;
        return this;
    }

    @Override
    @JsonProperty(value="sendToOwners")
    public Boolean getSendToOwners() {
        return this.sendToOwners;
    }

    @JsonProperty(value="sendToOwners")
    public void setSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
    }

    public Webhook withSendToOwners(Boolean sendToOwners) {
        this.sendToOwners = sendToOwners;
        return this;
    }

    @Override
    @JsonProperty(value="sendToFollowers")
    public Boolean getSendToFollowers() {
        return this.sendToFollowers;
    }

    @JsonProperty(value="sendToFollowers")
    public void setSendToFollowers(Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
    }

    public Webhook withSendToFollowers(Boolean sendToFollowers) {
        this.sendToFollowers = sendToFollowers;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Webhook.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("receivers");
        sb.append('=');
        sb.append(this.receivers == null ? "<null>" : this.receivers);
        sb.append(',');
        sb.append("endpoint");
        sb.append('=');
        sb.append(this.endpoint == null ? "<null>" : this.endpoint);
        sb.append(',');
        sb.append("secretKey");
        sb.append('=');
        sb.append(this.secretKey == null ? "<null>" : this.secretKey);
        sb.append(',');
        sb.append("sendToAdmins");
        sb.append('=');
        sb.append(this.sendToAdmins == null ? "<null>" : this.sendToAdmins);
        sb.append(',');
        sb.append("sendToOwners");
        sb.append('=');
        sb.append(this.sendToOwners == null ? "<null>" : this.sendToOwners);
        sb.append(',');
        sb.append("sendToFollowers");
        sb.append('=');
        sb.append(this.sendToFollowers == null ? "<null>" : this.sendToFollowers);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sendToAdmins == null ? 0 : this.sendToAdmins.hashCode());
        result = result * 31 + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = result * 31 + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        result = result * 31 + (this.sendToOwners == null ? 0 : this.sendToOwners.hashCode());
        result = result * 31 + (this.receivers == null ? 0 : this.receivers.hashCode());
        result = result * 31 + (this.sendToFollowers == null ? 0 : this.sendToFollowers.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Webhook)) {
            return false;
        }
        Webhook rhs = (Webhook)other;
        return (this.sendToAdmins == rhs.sendToAdmins || this.sendToAdmins != null && this.sendToAdmins.equals(rhs.sendToAdmins)) && (this.endpoint == rhs.endpoint || this.endpoint != null && this.endpoint.equals(rhs.endpoint)) && (this.secretKey == rhs.secretKey || this.secretKey != null && this.secretKey.equals(rhs.secretKey)) && (this.sendToOwners == rhs.sendToOwners || this.sendToOwners != null && this.sendToOwners.equals(rhs.sendToOwners)) && (this.receivers == rhs.receivers || this.receivers != null && this.receivers.equals(rhs.receivers)) && (this.sendToFollowers == rhs.sendToFollowers || this.sendToFollowers != null && this.sendToFollowers.equals(rhs.sendToFollowers));
    }
}

