/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import org.openmetadata.schema.type.ApiStatus;
import org.openmetadata.schema.type.api.BulkResponse;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"dryRun", "status", "abortReason", "numberOfRowsProcessed", "numberOfRowsPassed", "numberOfRowsFailed", "successRequest", "failedRequest"})
public class BulkOperationResult {
    @JsonProperty(value="dryRun")
    @JsonPropertyDescription(value="True if the operation has dryRun flag enabled")
    private Boolean dryRun;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="State of an action over API.")
    private ApiStatus status;
    @JsonProperty(value="abortReason")
    @JsonPropertyDescription(value="Reason why import was aborted. This is set only when the `status` field is set to `aborted`")
    private String abortReason;
    @JsonProperty(value="numberOfRowsProcessed")
    @JsonPropertyDescription(value="Type used to indicate row count")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer numberOfRowsProcessed = 0;
    @JsonProperty(value="numberOfRowsPassed")
    @JsonPropertyDescription(value="Type used to indicate row count")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer numberOfRowsPassed = 0;
    @JsonProperty(value="numberOfRowsFailed")
    @JsonPropertyDescription(value="Type used to indicate row count")
    @DecimalMin(value="0")
    private @DecimalMin(value="0") Integer numberOfRowsFailed = 0;
    @JsonProperty(value="successRequest")
    @JsonPropertyDescription(value="Request that can be processed successfully.")
    @Valid
    private List<BulkResponse> successRequest = null;
    @JsonProperty(value="failedRequest")
    @JsonPropertyDescription(value="Failure Request that can be processed successfully.")
    @Valid
    private List<BulkResponse> failedRequest = null;

    @JsonProperty(value="dryRun")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    @JsonProperty(value="dryRun")
    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public BulkOperationResult withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @JsonProperty(value="status")
    public ApiStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(ApiStatus status) {
        this.status = status;
    }

    public BulkOperationResult withStatus(ApiStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="abortReason")
    public String getAbortReason() {
        return this.abortReason;
    }

    @JsonProperty(value="abortReason")
    public void setAbortReason(String abortReason) {
        this.abortReason = abortReason;
    }

    public BulkOperationResult withAbortReason(String abortReason) {
        this.abortReason = abortReason;
        return this;
    }

    @JsonProperty(value="numberOfRowsProcessed")
    public Integer getNumberOfRowsProcessed() {
        return this.numberOfRowsProcessed;
    }

    @JsonProperty(value="numberOfRowsProcessed")
    public void setNumberOfRowsProcessed(Integer numberOfRowsProcessed) {
        this.numberOfRowsProcessed = numberOfRowsProcessed;
    }

    public BulkOperationResult withNumberOfRowsProcessed(Integer numberOfRowsProcessed) {
        this.numberOfRowsProcessed = numberOfRowsProcessed;
        return this;
    }

    @JsonProperty(value="numberOfRowsPassed")
    public Integer getNumberOfRowsPassed() {
        return this.numberOfRowsPassed;
    }

    @JsonProperty(value="numberOfRowsPassed")
    public void setNumberOfRowsPassed(Integer numberOfRowsPassed) {
        this.numberOfRowsPassed = numberOfRowsPassed;
    }

    public BulkOperationResult withNumberOfRowsPassed(Integer numberOfRowsPassed) {
        this.numberOfRowsPassed = numberOfRowsPassed;
        return this;
    }

    @JsonProperty(value="numberOfRowsFailed")
    public Integer getNumberOfRowsFailed() {
        return this.numberOfRowsFailed;
    }

    @JsonProperty(value="numberOfRowsFailed")
    public void setNumberOfRowsFailed(Integer numberOfRowsFailed) {
        this.numberOfRowsFailed = numberOfRowsFailed;
    }

    public BulkOperationResult withNumberOfRowsFailed(Integer numberOfRowsFailed) {
        this.numberOfRowsFailed = numberOfRowsFailed;
        return this;
    }

    @JsonProperty(value="successRequest")
    public List<BulkResponse> getSuccessRequest() {
        return this.successRequest;
    }

    @JsonProperty(value="successRequest")
    public void setSuccessRequest(List<BulkResponse> successRequest) {
        this.successRequest = successRequest;
    }

    public BulkOperationResult withSuccessRequest(List<BulkResponse> successRequest) {
        this.successRequest = successRequest;
        return this;
    }

    @JsonProperty(value="failedRequest")
    public List<BulkResponse> getFailedRequest() {
        return this.failedRequest;
    }

    @JsonProperty(value="failedRequest")
    public void setFailedRequest(List<BulkResponse> failedRequest) {
        this.failedRequest = failedRequest;
    }

    public BulkOperationResult withFailedRequest(List<BulkResponse> failedRequest) {
        this.failedRequest = failedRequest;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BulkOperationResult.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dryRun");
        sb.append('=');
        sb.append(this.dryRun == null ? "<null>" : this.dryRun);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("abortReason");
        sb.append('=');
        sb.append(this.abortReason == null ? "<null>" : this.abortReason);
        sb.append(',');
        sb.append("numberOfRowsProcessed");
        sb.append('=');
        sb.append(this.numberOfRowsProcessed == null ? "<null>" : this.numberOfRowsProcessed);
        sb.append(',');
        sb.append("numberOfRowsPassed");
        sb.append('=');
        sb.append(this.numberOfRowsPassed == null ? "<null>" : this.numberOfRowsPassed);
        sb.append(',');
        sb.append("numberOfRowsFailed");
        sb.append('=');
        sb.append(this.numberOfRowsFailed == null ? "<null>" : this.numberOfRowsFailed);
        sb.append(',');
        sb.append("successRequest");
        sb.append('=');
        sb.append(this.successRequest == null ? "<null>" : this.successRequest);
        sb.append(',');
        sb.append("failedRequest");
        sb.append('=');
        sb.append(this.failedRequest == null ? "<null>" : this.failedRequest);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.abortReason == null ? 0 : this.abortReason.hashCode());
        result = result * 31 + (this.successRequest == null ? 0 : this.successRequest.hashCode());
        result = result * 31 + (this.dryRun == null ? 0 : this.dryRun.hashCode());
        result = result * 31 + (this.numberOfRowsPassed == null ? 0 : this.numberOfRowsPassed.hashCode());
        result = result * 31 + (this.failedRequest == null ? 0 : this.failedRequest.hashCode());
        result = result * 31 + (this.numberOfRowsProcessed == null ? 0 : this.numberOfRowsProcessed.hashCode());
        result = result * 31 + (this.numberOfRowsFailed == null ? 0 : this.numberOfRowsFailed.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BulkOperationResult)) {
            return false;
        }
        BulkOperationResult rhs = (BulkOperationResult)other;
        return (this.abortReason == rhs.abortReason || this.abortReason != null && this.abortReason.equals(rhs.abortReason)) && (this.successRequest == rhs.successRequest || this.successRequest != null && this.successRequest.equals(rhs.successRequest)) && (this.dryRun == rhs.dryRun || this.dryRun != null && this.dryRun.equals(rhs.dryRun)) && (this.numberOfRowsPassed == rhs.numberOfRowsPassed || this.numberOfRowsPassed != null && this.numberOfRowsPassed.equals(rhs.numberOfRowsPassed)) && (this.failedRequest == rhs.failedRequest || this.failedRequest != null && this.failedRequest.equals(rhs.failedRequest)) && (this.numberOfRowsProcessed == rhs.numberOfRowsProcessed || this.numberOfRowsProcessed != null && this.numberOfRowsProcessed.equals(rhs.numberOfRowsProcessed)) && (this.numberOfRowsFailed == rhs.numberOfRowsFailed || this.numberOfRowsFailed != null && this.numberOfRowsFailed.equals(rhs.numberOfRowsFailed)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

