/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type.csv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CsvErrorType {
    UNKNOWN("UNKNOWN"),
    PARSER_FAILURE("PARSER_FAILURE"),
    INVALID_HEADER("INVALID_HEADER"),
    INVALID_FIELD_COUNT("INVALID_FIELD_COUNT"),
    FIELD_REQUIRED("FIELD_REQUIRED"),
    INVALID_FIELD("INVALID_FIELD");

    private final String value;
    private static final Map<String, CsvErrorType> CONSTANTS;

    private CsvErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CsvErrorType fromValue(String value) {
        CsvErrorType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CsvErrorType>();
        for (CsvErrorType c : CsvErrorType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

