/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type.customproperties;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openmetadata.schema.type.customproperties.Row;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"columns", "rows"})
public class Table {
    @JsonProperty(value="columns")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of column names defined at the entity type level.")
    @Size(min=1, max=3)
    @Valid
    @NotNull
    private @Size(min=1, max=3) @Valid @NotNull Set<String> columns = new LinkedHashSet<String>();
    @JsonProperty(value="rows")
    @JsonPropertyDescription(value="List of rows added at the entity instance level. Each row contains dynamic fields based on the defined columns.")
    @Valid
    private List<Row> rows = new ArrayList<Row>();

    @JsonProperty(value="columns")
    public Set<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(Set<String> columns) {
        this.columns = columns;
    }

    public Table withColumns(Set<String> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="rows")
    public List<Row> getRows() {
        return this.rows;
    }

    @JsonProperty(value="rows")
    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public Table withRows(List<Row> rows) {
        this.rows = rows;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Table.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("rows");
        sb.append('=');
        sb.append(this.rows == null ? "<null>" : this.rows);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.rows == null ? 0 : this.rows.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Table)) {
            return false;
        }
        Table rhs = (Table)other;
        return (this.rows == rhs.rows || this.rows != null && this.rows.equals(rhs.rows)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns));
    }
}

