/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.schema.type.customproperties;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"columns", "minColumns", "maxColumns"})
public class TableConfig {
    @JsonProperty(value="columns")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="List of column names defined at the entity type level.")
    @Size(min=1, max=3)
    @Valid
    @NotNull
    private @Size(min=1, max=3) @Valid @NotNull Set<String> columns = new LinkedHashSet<String>();
    @JsonProperty(value="minColumns")
    private Integer minColumns = 1;
    @JsonProperty(value="maxColumns")
    private Integer maxColumns = 3;

    @JsonProperty(value="columns")
    public Set<String> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    public void setColumns(Set<String> columns) {
        this.columns = columns;
    }

    public TableConfig withColumns(Set<String> columns) {
        this.columns = columns;
        return this;
    }

    @JsonProperty(value="minColumns")
    public Integer getMinColumns() {
        return this.minColumns;
    }

    @JsonProperty(value="minColumns")
    public void setMinColumns(Integer minColumns) {
        this.minColumns = minColumns;
    }

    public TableConfig withMinColumns(Integer minColumns) {
        this.minColumns = minColumns;
        return this;
    }

    @JsonProperty(value="maxColumns")
    public Integer getMaxColumns() {
        return this.maxColumns;
    }

    @JsonProperty(value="maxColumns")
    public void setMaxColumns(Integer maxColumns) {
        this.maxColumns = maxColumns;
    }

    public TableConfig withMaxColumns(Integer maxColumns) {
        this.maxColumns = maxColumns;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TableConfig.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("columns");
        sb.append('=');
        sb.append(this.columns == null ? "<null>" : this.columns);
        sb.append(',');
        sb.append("minColumns");
        sb.append('=');
        sb.append(this.minColumns == null ? "<null>" : this.minColumns);
        sb.append(',');
        sb.append("maxColumns");
        sb.append('=');
        sb.append(this.maxColumns == null ? "<null>" : this.maxColumns);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.maxColumns == null ? 0 : this.maxColumns.hashCode());
        result = result * 31 + (this.columns == null ? 0 : this.columns.hashCode());
        result = result * 31 + (this.minColumns == null ? 0 : this.minColumns.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableConfig)) {
            return false;
        }
        TableConfig rhs = (TableConfig)other;
        return (this.maxColumns == rhs.maxColumns || this.maxColumns != null && this.maxColumns.equals(rhs.maxColumns)) && (this.columns == rhs.columns || this.columns != null && this.columns.equals(rhs.columns)) && (this.minColumns == rhs.minColumns || this.minColumns != null && this.minColumns.equals(rhs.minColumns));
    }
}

