/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.sdk;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppMarketPlaceDefinition;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineServiceClientResponse;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineType;

public interface PipelineServiceClientInterface {
    public static final String HEALTHY_STATUS = "healthy";
    public static final String UNHEALTHY_STATUS = "unhealthy";
    public static final String STATUS_KEY = "status";
    public static final String APP_TRIGGER = "run_application";
    public static final String DEPLOYMENT_ERROR = "DEPLOYMENT_ERROR";
    public static final String TRIGGER_ERROR = "TRIGGER_ERROR";
    public static final Map<String, String> TYPE_TO_TASK = Map.of(PipelineType.METADATA.toString(), "ingestion_task", PipelineType.PROFILER.toString(), "profiler_task", PipelineType.LINEAGE.toString(), "lineage_task", PipelineType.DBT.toString(), "dbt_task", PipelineType.USAGE.toString(), "usage_task", PipelineType.TEST_SUITE.toString(), "test_suite_task", PipelineType.DATA_INSIGHT.toString(), "data_insight_task", PipelineType.APPLICATION.toString(), "application_task");

    public URL validateServiceURL(String var1);

    public String getBasicAuthenticationHeader(String var1, String var2);

    public Boolean validServerClientVersions(String var1);

    public Response getHostIp();

    public String getServiceStatusBackoff();

    public PipelineServiceClientResponse getServiceStatus();

    public List<PipelineStatus> getQueuedPipelineStatus(IngestionPipeline var1);

    public PipelineServiceClientResponse runAutomationsWorkflow(Workflow var1);

    public PipelineServiceClientResponse runApplicationFlow(App var1);

    public PipelineServiceClientResponse validateAppRegistration(AppMarketPlaceDefinition var1);

    public PipelineServiceClientResponse deployPipeline(IngestionPipeline var1, ServiceEntityInterface var2);

    public PipelineServiceClientResponse runPipeline(IngestionPipeline var1, ServiceEntityInterface var2);

    public PipelineServiceClientResponse deletePipeline(IngestionPipeline var1);

    public List<PipelineStatus> getQueuedPipelineStatusInternal(IngestionPipeline var1);

    public PipelineServiceClientResponse toggleIngestion(IngestionPipeline var1);

    public Map<String, String> getLastIngestionLogs(IngestionPipeline var1, String var2);

    public PipelineServiceClientResponse killIngestion(IngestionPipeline var1);

    public String getPlatform();
}

