/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.sdk.exception;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public abstract class WebServiceException
extends RuntimeException {
    private final transient Response response;

    protected WebServiceException(Response response, String msg) {
        super(msg);
        this.response = response;
    }

    protected WebServiceException(Response.Status status, String errorType, String msg) {
        super(msg);
        this.response = Response.status((Response.Status)status).entity((Object)WebServiceException.convertToErrorResponseMessage(errorType, msg)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected WebServiceException(int status, String errorType, String msg) {
        super(msg);
        this.response = Response.status((int)status).entity((Object)WebServiceException.convertToErrorResponseMessage(errorType, msg)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected WebServiceException(Response.Status status, String errorType, String msg, Throwable cause) {
        super(msg, cause);
        this.response = Response.status((Response.Status)status).entity((Object)WebServiceException.convertToErrorResponseMessage(errorType, msg)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static ErrorResponse convertToErrorResponseMessage(String errorType, String msg) {
        return new ErrorResponse(errorType, msg);
    }

    public Response getResponse() {
        return this.response;
    }

    private static class ErrorResponse {
        private final String responseMessage;
        private final String errorType;

        ErrorResponse(String errorType, String responseMessage) {
            this.responseMessage = responseMessage;
            this.errorType = errorType;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public String getErrorType() {
            return this.errorType;
        }
    }
}

