/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.empoa.swagger.core.internal.models;

import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.openapitools.empoa.swagger.core.internal.models.SwOperation;
import org.openapitools.empoa.swagger.core.internal.models.parameters.SwParameter;
import org.openapitools.empoa.swagger.core.internal.models.servers.SwServer;

public class SwPathItem
implements org.eclipse.microprofile.openapi.models.PathItem {
    private PathItem _swPathItem;
    private SwOperation _gET;
    private SwOperation _pUT;
    private SwOperation _pOST;
    private SwOperation _dELETE;
    private SwOperation _oPTIONS;
    private SwOperation _hEAD;
    private SwOperation _pATCH;
    private SwOperation _tRACE;
    private List<SwServer> _servers;
    private List<SwParameter> _parameters;

    public SwPathItem() {
        this._swPathItem = new PathItem();
    }

    public SwPathItem(PathItem _swPathItem) {
        this._swPathItem = _swPathItem;
    }

    public PathItem getSw() {
        return this._swPathItem;
    }

    @Override
    public String getRef() {
        return this._swPathItem.get$ref();
    }

    @Override
    public void setRef(String ref) {
        this._swPathItem.set$ref(ref);
    }

    @Override
    public Map<String, Object> getExtensions() {
        Map<String, Object> result = this._swPathItem.getExtensions();
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void setExtensions(Map<String, Object> extensions) {
        this._swPathItem.setExtensions(null);
        if (extensions != null) {
            if (extensions.isEmpty()) {
                this._swPathItem.setExtensions(new LinkedHashMap<String, Object>());
            } else {
                for (Map.Entry<String, Object> e : extensions.entrySet()) {
                    this.addExtension(e.getKey(), e.getValue());
                }
            }
        }
    }

    @Override
    public org.eclipse.microprofile.openapi.models.PathItem addExtension(String key, Object object) {
        this._swPathItem.addExtension(key, object);
        return this;
    }

    @Override
    public void removeExtension(String key) {
        if (this.getExtensions() != null) {
            this._swPathItem.getExtensions().remove(key);
        }
    }

    @Override
    public String getSummary() {
        return this._swPathItem.getSummary();
    }

    @Override
    public void setSummary(String summary) {
        this._swPathItem.setSummary(summary);
    }

    @Override
    public String getDescription() {
        return this._swPathItem.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this._swPathItem.setDescription(description);
    }

    private void initGET() {
        if (this._swPathItem.getGet() == null) {
            this._gET = null;
        } else if (this._gET == null) {
            this._gET = new SwOperation(this._swPathItem.getGet());
        }
    }

    @Override
    public Operation getGET() {
        this.initGET();
        return this._gET;
    }

    @Override
    public void setGET(Operation gET) {
        if (gET != null) {
            if (!(gET instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + gET);
            }
            this._gET = (SwOperation)gET;
            this._swPathItem.setGet(this._gET.getSw());
        } else {
            this._gET = null;
            this._swPathItem.setGet(null);
        }
    }

    private void initPUT() {
        if (this._swPathItem.getPut() == null) {
            this._pUT = null;
        } else if (this._pUT == null) {
            this._pUT = new SwOperation(this._swPathItem.getPut());
        }
    }

    @Override
    public Operation getPUT() {
        this.initPUT();
        return this._pUT;
    }

    @Override
    public void setPUT(Operation pUT) {
        if (pUT != null) {
            if (!(pUT instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + pUT);
            }
            this._pUT = (SwOperation)pUT;
            this._swPathItem.setPut(this._pUT.getSw());
        } else {
            this._pUT = null;
            this._swPathItem.setPut(null);
        }
    }

    private void initPOST() {
        if (this._swPathItem.getPost() == null) {
            this._pOST = null;
        } else if (this._pOST == null) {
            this._pOST = new SwOperation(this._swPathItem.getPost());
        }
    }

    @Override
    public Operation getPOST() {
        this.initPOST();
        return this._pOST;
    }

    @Override
    public void setPOST(Operation pOST) {
        if (pOST != null) {
            if (!(pOST instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + pOST);
            }
            this._pOST = (SwOperation)pOST;
            this._swPathItem.setPost(this._pOST.getSw());
        } else {
            this._pOST = null;
            this._swPathItem.setPost(null);
        }
    }

    private void initDELETE() {
        if (this._swPathItem.getDelete() == null) {
            this._dELETE = null;
        } else if (this._dELETE == null) {
            this._dELETE = new SwOperation(this._swPathItem.getDelete());
        }
    }

    @Override
    public Operation getDELETE() {
        this.initDELETE();
        return this._dELETE;
    }

    @Override
    public void setDELETE(Operation dELETE) {
        if (dELETE != null) {
            if (!(dELETE instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + dELETE);
            }
            this._dELETE = (SwOperation)dELETE;
            this._swPathItem.setDelete(this._dELETE.getSw());
        } else {
            this._dELETE = null;
            this._swPathItem.setDelete(null);
        }
    }

    private void initOPTIONS() {
        if (this._swPathItem.getOptions() == null) {
            this._oPTIONS = null;
        } else if (this._oPTIONS == null) {
            this._oPTIONS = new SwOperation(this._swPathItem.getOptions());
        }
    }

    @Override
    public Operation getOPTIONS() {
        this.initOPTIONS();
        return this._oPTIONS;
    }

    @Override
    public void setOPTIONS(Operation oPTIONS) {
        if (oPTIONS != null) {
            if (!(oPTIONS instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + oPTIONS);
            }
            this._oPTIONS = (SwOperation)oPTIONS;
            this._swPathItem.setOptions(this._oPTIONS.getSw());
        } else {
            this._oPTIONS = null;
            this._swPathItem.setOptions(null);
        }
    }

    private void initHEAD() {
        if (this._swPathItem.getHead() == null) {
            this._hEAD = null;
        } else if (this._hEAD == null) {
            this._hEAD = new SwOperation(this._swPathItem.getHead());
        }
    }

    @Override
    public Operation getHEAD() {
        this.initHEAD();
        return this._hEAD;
    }

    @Override
    public void setHEAD(Operation hEAD) {
        if (hEAD != null) {
            if (!(hEAD instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + hEAD);
            }
            this._hEAD = (SwOperation)hEAD;
            this._swPathItem.setHead(this._hEAD.getSw());
        } else {
            this._hEAD = null;
            this._swPathItem.setHead(null);
        }
    }

    private void initPATCH() {
        if (this._swPathItem.getPatch() == null) {
            this._pATCH = null;
        } else if (this._pATCH == null) {
            this._pATCH = new SwOperation(this._swPathItem.getPatch());
        }
    }

    @Override
    public Operation getPATCH() {
        this.initPATCH();
        return this._pATCH;
    }

    @Override
    public void setPATCH(Operation pATCH) {
        if (pATCH != null) {
            if (!(pATCH instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + pATCH);
            }
            this._pATCH = (SwOperation)pATCH;
            this._swPathItem.setPatch(this._pATCH.getSw());
        } else {
            this._pATCH = null;
            this._swPathItem.setPatch(null);
        }
    }

    private void initTRACE() {
        if (this._swPathItem.getTrace() == null) {
            this._tRACE = null;
        } else if (this._tRACE == null) {
            this._tRACE = new SwOperation(this._swPathItem.getTrace());
        }
    }

    @Override
    public Operation getTRACE() {
        this.initTRACE();
        return this._tRACE;
    }

    @Override
    public void setTRACE(Operation tRACE) {
        if (tRACE != null) {
            if (!(tRACE instanceof SwOperation)) {
                throw new IllegalArgumentException("Unexpected type: " + tRACE);
            }
            this._tRACE = (SwOperation)tRACE;
            this._swPathItem.setTrace(this._tRACE.getSw());
        } else {
            this._tRACE = null;
            this._swPathItem.setTrace(null);
        }
    }

    @Override
    public Map<PathItem.HttpMethod, Operation> getOperations() {
        LinkedHashMap<PathItem.HttpMethod, Operation> map = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        if (this.getGET() != null) {
            map.put(PathItem.HttpMethod.GET, this.getGET());
        }
        if (this.getPUT() != null) {
            map.put(PathItem.HttpMethod.PUT, this.getPUT());
        }
        if (this.getPOST() != null) {
            map.put(PathItem.HttpMethod.POST, this.getPOST());
        }
        if (this.getDELETE() != null) {
            map.put(PathItem.HttpMethod.DELETE, this.getDELETE());
        }
        if (this.getOPTIONS() != null) {
            map.put(PathItem.HttpMethod.OPTIONS, this.getOPTIONS());
        }
        if (this.getHEAD() != null) {
            map.put(PathItem.HttpMethod.HEAD, this.getHEAD());
        }
        if (this.getPATCH() != null) {
            map.put(PathItem.HttpMethod.PATCH, this.getPATCH());
        }
        if (this.getTRACE() != null) {
            map.put(PathItem.HttpMethod.TRACE, this.getTRACE());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void setOperation(PathItem.HttpMethod httpMethod, Operation operation) {
        if (httpMethod == null) {
            throw new IllegalArgumentException("parameter httpMethod can not be null");
        }
        switch (httpMethod) {
            case DELETE: {
                this.setDELETE(operation);
                break;
            }
            case GET: {
                this.setGET(operation);
                break;
            }
            case HEAD: {
                this.setHEAD(operation);
                break;
            }
            case OPTIONS: {
                this.setOPTIONS(operation);
                break;
            }
            case PATCH: {
                this.setPATCH(operation);
                break;
            }
            case POST: {
                this.setPOST(operation);
                break;
            }
            case PUT: {
                this.setPUT(operation);
                break;
            }
            case TRACE: {
                this.setTRACE(operation);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected httpMethod: " + (Object)((Object)httpMethod));
            }
        }
    }

    private void initServers() {
        if (this._swPathItem.getServers() == null) {
            this._servers = null;
        } else if (this._servers == null) {
            this._servers = this._swPathItem.getServers().stream().map(SwServer::new).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    @Override
    public List<org.eclipse.microprofile.openapi.models.servers.Server> getServers() {
        this.initServers();
        if (this._servers == null) {
            return null;
        }
        return Collections.unmodifiableList(this._servers);
    }

    @Override
    public void setServers(List<org.eclipse.microprofile.openapi.models.servers.Server> servers) {
        this._swPathItem.setServers(null);
        if (servers != null) {
            if (servers.isEmpty()) {
                this._swPathItem.setServers(new ArrayList<Server>());
            } else {
                for (org.eclipse.microprofile.openapi.models.servers.Server e : servers) {
                    this.addServer(e);
                }
            }
        }
    }

    @Override
    public org.eclipse.microprofile.openapi.models.PathItem addServer(org.eclipse.microprofile.openapi.models.servers.Server server) {
        if (!(server instanceof SwServer)) {
            throw new IllegalArgumentException("Unexpected type: " + server);
        }
        SwServer element = (SwServer)server;
        this.initServers();
        if (this._servers == null) {
            this._servers = new ArrayList<SwServer>();
            this._swPathItem.setServers(new ArrayList<Server>());
        }
        this._servers.add(element);
        this._swPathItem.getServers().add(element.getSw());
        return this;
    }

    @Override
    public void removeServer(org.eclipse.microprofile.openapi.models.servers.Server server) {
        if (!(server instanceof SwServer)) {
            throw new IllegalArgumentException("Unexpected type: " + server);
        }
        SwServer element = (SwServer)server;
        this.initServers();
        if (this._servers != null) {
            this._servers.remove(server);
            this._swPathItem.getServers().remove(element.getSw());
        }
    }

    private void initParameters() {
        if (this._swPathItem.getParameters() == null) {
            this._parameters = null;
        } else if (this._parameters == null) {
            this._parameters = this._swPathItem.getParameters().stream().map(SwParameter::new).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    @Override
    public List<org.eclipse.microprofile.openapi.models.parameters.Parameter> getParameters() {
        this.initParameters();
        if (this._parameters == null) {
            return null;
        }
        return Collections.unmodifiableList(this._parameters);
    }

    @Override
    public void setParameters(List<org.eclipse.microprofile.openapi.models.parameters.Parameter> parameters) {
        this._swPathItem.setParameters(null);
        if (parameters != null) {
            if (parameters.isEmpty()) {
                this._swPathItem.setParameters(new ArrayList<Parameter>());
            } else {
                for (org.eclipse.microprofile.openapi.models.parameters.Parameter e : parameters) {
                    this.addParameter(e);
                }
            }
        }
    }

    @Override
    public org.eclipse.microprofile.openapi.models.PathItem addParameter(org.eclipse.microprofile.openapi.models.parameters.Parameter parameter) {
        if (!(parameter instanceof SwParameter)) {
            throw new IllegalArgumentException("Unexpected type: " + parameter);
        }
        SwParameter element = (SwParameter)parameter;
        this.initParameters();
        if (this._parameters == null) {
            this._parameters = new ArrayList<SwParameter>();
            this._swPathItem.setParameters(new ArrayList<Parameter>());
        }
        this._parameters.add(element);
        this._swPathItem.getParameters().add(element.getSw());
        return this;
    }

    @Override
    public void removeParameter(org.eclipse.microprofile.openapi.models.parameters.Parameter parameter) {
        if (!(parameter instanceof SwParameter)) {
            throw new IllegalArgumentException("Unexpected type: " + parameter);
        }
        SwParameter element = (SwParameter)parameter;
        this.initParameters();
        if (this._parameters != null) {
            this._parameters.remove(parameter);
            this._swPathItem.getParameters().remove(element.getSw());
        }
    }
}

