/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.empoa.swagger.core.internal.models.media;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.openapitools.empoa.swagger.core.internal.models.media.SwMediaType;

public class SwContent
implements org.eclipse.microprofile.openapi.models.media.Content {
    private Content _swContent;
    private Map<String, SwMediaType> _mediaTypes;

    public SwContent() {
        this._swContent = new Content();
    }

    public SwContent(Content _swContent) {
        this._swContent = _swContent;
    }

    public Content getSw() {
        return this._swContent;
    }

    private void initMediaTypes() {
        if (this._swContent == null) {
            this._mediaTypes = null;
        } else if (this._mediaTypes == null) {
            this._mediaTypes = this._swContent.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SwMediaType((MediaType)e.getValue()), (k1, k2) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", k1));
            }, () -> new LinkedHashMap()));
        }
    }

    @Override
    public Map<String, org.eclipse.microprofile.openapi.models.media.MediaType> getMediaTypes() {
        this.initMediaTypes();
        if (this._mediaTypes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._mediaTypes);
    }

    @Override
    public void setMediaTypes(Map<String, org.eclipse.microprofile.openapi.models.media.MediaType> mediaTypes) {
        this._swContent.clear();
        if (mediaTypes != null) {
            if (mediaTypes.isEmpty()) {
                this._mediaTypes = new LinkedHashMap<String, SwMediaType>();
            } else {
                for (Map.Entry<String, org.eclipse.microprofile.openapi.models.media.MediaType> e : mediaTypes.entrySet()) {
                    this.addMediaType(e.getKey(), e.getValue());
                }
            }
        }
    }

    @Override
    public org.eclipse.microprofile.openapi.models.media.Content addMediaType(String key, org.eclipse.microprofile.openapi.models.media.MediaType mediaType) {
        if (!(mediaType instanceof SwMediaType)) {
            throw new IllegalArgumentException("Unexpected type: " + mediaType);
        }
        SwMediaType value = (SwMediaType)mediaType;
        this.initMediaTypes();
        if (this._mediaTypes == null) {
            this._mediaTypes = new LinkedHashMap<String, SwMediaType>();
        }
        this._mediaTypes.put(key, value);
        this._swContent.put(key, value.getSw());
        return this;
    }

    @Override
    public void removeMediaType(String key) {
        this.initMediaTypes();
        if (this._mediaTypes != null) {
            this._mediaTypes.remove(key);
            this._swContent.remove(key);
        }
    }
}

