/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.empoa.swagger.core.internal.models.parameters;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.openapitools.empoa.swagger.core.internal.models.examples.SwExample;
import org.openapitools.empoa.swagger.core.internal.models.media.SwContent;
import org.openapitools.empoa.swagger.core.internal.models.media.SwSchema;

public class SwParameter
implements org.eclipse.microprofile.openapi.models.parameters.Parameter {
    private Parameter _swParameter;
    private SwSchema _schema;
    private Map<String, SwExample> _examples;
    private SwContent _content;

    public SwParameter() {
        this._swParameter = new Parameter();
    }

    public SwParameter(Parameter _swParameter) {
        this._swParameter = _swParameter;
    }

    public Parameter getSw() {
        return this._swParameter;
    }

    @Override
    public String getRef() {
        return this._swParameter.get$ref();
    }

    @Override
    public void setRef(String ref) {
        this._swParameter.set$ref(ref);
    }

    @Override
    public Map<String, Object> getExtensions() {
        Map<String, Object> result = this._swParameter.getExtensions();
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void setExtensions(Map<String, Object> extensions) {
        this._swParameter.setExtensions(null);
        if (extensions != null) {
            if (extensions.isEmpty()) {
                this._swParameter.setExtensions(new LinkedHashMap<String, Object>());
            } else {
                for (Map.Entry<String, Object> e : extensions.entrySet()) {
                    this.addExtension(e.getKey(), e.getValue());
                }
            }
        }
    }

    @Override
    public org.eclipse.microprofile.openapi.models.parameters.Parameter addExtension(String key, Object object) {
        this._swParameter.addExtension(key, object);
        return this;
    }

    @Override
    public void removeExtension(String key) {
        if (this.getExtensions() != null) {
            this._swParameter.getExtensions().remove(key);
        }
    }

    @Override
    public String getName() {
        return this._swParameter.getName();
    }

    @Override
    public void setName(String name) {
        this._swParameter.setName(name);
    }

    @Override
    public Parameter.In getIn() {
        if (this._swParameter.getIn() == null) {
            return null;
        }
        switch (this._swParameter.getIn().toLowerCase()) {
            case "cookie": {
                return Parameter.In.COOKIE;
            }
            case "header": {
                return Parameter.In.HEADER;
            }
            case "path": {
                return Parameter.In.PATH;
            }
            case "query": {
                return Parameter.In.QUERY;
            }
        }
        throw new IllegalStateException("Unexpected enum value: " + this._swParameter.getIn());
    }

    @Override
    public void setIn(Parameter.In in) {
        if (in == null) {
            this._swParameter.setIn(null);
        } else {
            this._swParameter.setIn(in.toString());
        }
    }

    @Override
    public String getDescription() {
        return this._swParameter.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this._swParameter.setDescription(description);
    }

    @Override
    public Boolean getRequired() {
        return this._swParameter.getRequired();
    }

    @Override
    public void setRequired(Boolean required) {
        this._swParameter.setRequired(required);
    }

    @Override
    public Boolean getDeprecated() {
        return this._swParameter.getDeprecated();
    }

    @Override
    public void setDeprecated(Boolean deprecated) {
        this._swParameter.setDeprecated(deprecated);
    }

    @Override
    public Boolean getAllowEmptyValue() {
        return this._swParameter.getAllowEmptyValue();
    }

    @Override
    public void setAllowEmptyValue(Boolean allowEmptyValue) {
        this._swParameter.setAllowEmptyValue(allowEmptyValue);
    }

    @Override
    public Parameter.Style getStyle() {
        if (this._swParameter.getStyle() == null) {
            return null;
        }
        switch (this._swParameter.getStyle()) {
            case MATRIX: {
                return Parameter.Style.MATRIX;
            }
            case LABEL: {
                return Parameter.Style.LABEL;
            }
            case FORM: {
                return Parameter.Style.FORM;
            }
            case SIMPLE: {
                return Parameter.Style.SIMPLE;
            }
            case SPACEDELIMITED: {
                return Parameter.Style.SPACEDELIMITED;
            }
            case PIPEDELIMITED: {
                return Parameter.Style.PIPEDELIMITED;
            }
            case DEEPOBJECT: {
                return Parameter.Style.DEEPOBJECT;
            }
        }
        throw new IllegalStateException("Unexpected enum value: " + (Object)((Object)this._swParameter.getStyle()));
    }

    @Override
    public void setStyle(Parameter.Style style) {
        Parameter.StyleEnum value;
        if (style == null) {
            value = null;
        } else {
            switch (style) {
                case MATRIX: {
                    value = Parameter.StyleEnum.MATRIX;
                    break;
                }
                case LABEL: {
                    value = Parameter.StyleEnum.LABEL;
                    break;
                }
                case FORM: {
                    value = Parameter.StyleEnum.FORM;
                    break;
                }
                case SIMPLE: {
                    value = Parameter.StyleEnum.SIMPLE;
                    break;
                }
                case SPACEDELIMITED: {
                    value = Parameter.StyleEnum.SPACEDELIMITED;
                    break;
                }
                case PIPEDELIMITED: {
                    value = Parameter.StyleEnum.PIPEDELIMITED;
                    break;
                }
                case DEEPOBJECT: {
                    value = Parameter.StyleEnum.DEEPOBJECT;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected enum value: " + (Object)((Object)style));
                }
            }
        }
        this._swParameter.setStyle(value);
    }

    @Override
    public Boolean getExplode() {
        return this._swParameter.getExplode();
    }

    @Override
    public void setExplode(Boolean explode) {
        this._swParameter.setExplode(explode);
    }

    @Override
    public Boolean getAllowReserved() {
        return this._swParameter.getAllowReserved();
    }

    @Override
    public void setAllowReserved(Boolean allowReserved) {
        this._swParameter.setAllowReserved(allowReserved);
    }

    private void initSchema() {
        if (this._swParameter.getSchema() == null) {
            this._schema = null;
        } else if (this._schema == null) {
            this._schema = new SwSchema(this._swParameter.getSchema());
        }
    }

    @Override
    public Schema getSchema() {
        this.initSchema();
        return this._schema;
    }

    @Override
    public void setSchema(Schema schema) {
        if (schema != null) {
            if (!(schema instanceof SwSchema)) {
                throw new IllegalArgumentException("Unexpected type: " + schema);
            }
            this._schema = (SwSchema)schema;
            this._swParameter.setSchema(this._schema.getSw());
        } else {
            this._schema = null;
            this._swParameter.setSchema(null);
        }
    }

    private void initExamples() {
        if (this._swParameter.getExamples() == null) {
            this._examples = null;
        } else if (this._examples == null) {
            this._examples = this._swParameter.getExamples().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SwExample((io.swagger.v3.oas.models.examples.Example)e.getValue()), (k1, k2) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", k1));
            }, () -> new LinkedHashMap()));
        }
    }

    @Override
    public Map<String, Example> getExamples() {
        this.initExamples();
        if (this._examples == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._examples);
    }

    @Override
    public void setExamples(Map<String, Example> examples) {
        this._swParameter.setExamples(null);
        if (examples != null) {
            if (examples.isEmpty()) {
                this._swParameter.setExamples(new LinkedHashMap<String, io.swagger.v3.oas.models.examples.Example>());
            } else {
                for (Map.Entry<String, Example> e : examples.entrySet()) {
                    this.addExample(e.getKey(), e.getValue());
                }
            }
        }
    }

    @Override
    public org.eclipse.microprofile.openapi.models.parameters.Parameter addExample(String key, Example example) {
        if (!(example instanceof SwExample)) {
            throw new IllegalArgumentException("Unexpected type: " + example);
        }
        SwExample value = (SwExample)example;
        this.initExamples();
        if (this._examples == null) {
            this._examples = new LinkedHashMap<String, SwExample>();
            this._swParameter.setExamples(new LinkedHashMap<String, io.swagger.v3.oas.models.examples.Example>());
        }
        this._examples.put(key, value);
        this._swParameter.getExamples().put(key, value.getSw());
        return this;
    }

    @Override
    public void removeExample(String key) {
        this.initExamples();
        if (this._examples != null) {
            this._examples.remove(key);
            this._swParameter.getExamples().remove(key);
        }
    }

    @Override
    public Object getExample() {
        return this._swParameter.getExample();
    }

    @Override
    public void setExample(Object example) {
        this._swParameter.setExample(example);
    }

    private void initContent() {
        if (this._swParameter.getContent() == null) {
            this._content = null;
        } else if (this._content == null) {
            this._content = new SwContent(this._swParameter.getContent());
        }
    }

    @Override
    public Content getContent() {
        this.initContent();
        return this._content;
    }

    @Override
    public void setContent(Content content) {
        if (content != null) {
            if (!(content instanceof SwContent)) {
                throw new IllegalArgumentException("Unexpected type: " + content);
            }
            this._content = (SwContent)content;
            this._swParameter.setContent(this._content.getSw());
        } else {
            this._content = null;
            this._swParameter.setContent(null);
        }
    }
}

