/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.empoa.swagger.core.internal.models.security;

import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.openapitools.empoa.swagger.core.internal.models.security.SwOAuthFlows;

public class SwSecurityScheme
implements SecurityScheme {
    private io.swagger.v3.oas.models.security.SecurityScheme _swSecurityScheme;
    private SwOAuthFlows _flows;

    public SwSecurityScheme() {
        this._swSecurityScheme = new io.swagger.v3.oas.models.security.SecurityScheme();
    }

    public SwSecurityScheme(io.swagger.v3.oas.models.security.SecurityScheme _swSecurityScheme) {
        this._swSecurityScheme = _swSecurityScheme;
    }

    public io.swagger.v3.oas.models.security.SecurityScheme getSw() {
        return this._swSecurityScheme;
    }

    @Override
    public String getRef() {
        return this._swSecurityScheme.get$ref();
    }

    @Override
    public void setRef(String ref) {
        this._swSecurityScheme.set$ref(ref);
    }

    @Override
    public Map<String, Object> getExtensions() {
        Map<String, Object> result = this._swSecurityScheme.getExtensions();
        if (result == null) {
            return null;
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void setExtensions(Map<String, Object> extensions) {
        this._swSecurityScheme.setExtensions(null);
        if (extensions != null) {
            if (extensions.isEmpty()) {
                this._swSecurityScheme.setExtensions(new LinkedHashMap<String, Object>());
            } else {
                for (Map.Entry<String, Object> e : extensions.entrySet()) {
                    this.addExtension(e.getKey(), e.getValue());
                }
            }
        }
    }

    @Override
    public SecurityScheme addExtension(String key, Object object) {
        this._swSecurityScheme.addExtension(key, object);
        return this;
    }

    @Override
    public void removeExtension(String key) {
        if (this.getExtensions() != null) {
            this._swSecurityScheme.getExtensions().remove(key);
        }
    }

    @Override
    public SecurityScheme.Type getType() {
        if (this._swSecurityScheme.getType() == null) {
            return null;
        }
        switch (this._swSecurityScheme.getType()) {
            case APIKEY: {
                return SecurityScheme.Type.APIKEY;
            }
            case HTTP: {
                return SecurityScheme.Type.HTTP;
            }
            case OAUTH2: {
                return SecurityScheme.Type.OAUTH2;
            }
            case OPENIDCONNECT: {
                return SecurityScheme.Type.OPENIDCONNECT;
            }
        }
        throw new IllegalStateException("Unexpected enum value: " + (Object)((Object)this._swSecurityScheme.getType()));
    }

    @Override
    public void setType(SecurityScheme.Type type) {
        SecurityScheme.Type value;
        if (type == null) {
            value = null;
        } else {
            switch (type) {
                case APIKEY: {
                    value = SecurityScheme.Type.APIKEY;
                    break;
                }
                case HTTP: {
                    value = SecurityScheme.Type.HTTP;
                    break;
                }
                case OAUTH2: {
                    value = SecurityScheme.Type.OAUTH2;
                    break;
                }
                case OPENIDCONNECT: {
                    value = SecurityScheme.Type.OPENIDCONNECT;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected enum value: " + (Object)((Object)type));
                }
            }
        }
        this._swSecurityScheme.setType(value);
    }

    @Override
    public String getDescription() {
        return this._swSecurityScheme.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this._swSecurityScheme.setDescription(description);
    }

    @Override
    public String getName() {
        return this._swSecurityScheme.getName();
    }

    @Override
    public void setName(String name) {
        this._swSecurityScheme.setName(name);
    }

    @Override
    public SecurityScheme.In getIn() {
        if (this._swSecurityScheme.getIn() == null) {
            return null;
        }
        switch (this._swSecurityScheme.getIn()) {
            case COOKIE: {
                return SecurityScheme.In.COOKIE;
            }
            case HEADER: {
                return SecurityScheme.In.HEADER;
            }
            case QUERY: {
                return SecurityScheme.In.QUERY;
            }
        }
        throw new IllegalStateException("Unexpected enum value :" + (Object)((Object)this._swSecurityScheme.getIn()));
    }

    @Override
    public void setIn(SecurityScheme.In in) {
        SecurityScheme.In value;
        if (in == null) {
            value = null;
        } else {
            switch (in) {
                case COOKIE: {
                    value = SecurityScheme.In.COOKIE;
                    break;
                }
                case HEADER: {
                    value = SecurityScheme.In.HEADER;
                    break;
                }
                case QUERY: {
                    value = SecurityScheme.In.QUERY;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected enum value: " + (Object)((Object)in));
                }
            }
        }
        this._swSecurityScheme.setIn(value);
    }

    @Override
    public String getScheme() {
        return this._swSecurityScheme.getScheme();
    }

    @Override
    public void setScheme(String scheme) {
        this._swSecurityScheme.setScheme(scheme);
    }

    @Override
    public String getBearerFormat() {
        return this._swSecurityScheme.getBearerFormat();
    }

    @Override
    public void setBearerFormat(String bearerFormat) {
        this._swSecurityScheme.setBearerFormat(bearerFormat);
    }

    private void initFlows() {
        if (this._swSecurityScheme.getFlows() == null) {
            this._flows = null;
        } else if (this._flows == null) {
            this._flows = new SwOAuthFlows(this._swSecurityScheme.getFlows());
        }
    }

    @Override
    public OAuthFlows getFlows() {
        this.initFlows();
        return this._flows;
    }

    @Override
    public void setFlows(OAuthFlows flows) {
        if (flows != null) {
            if (!(flows instanceof SwOAuthFlows)) {
                throw new IllegalArgumentException("Unexpected type: " + flows);
            }
            this._flows = (SwOAuthFlows)flows;
            this._swSecurityScheme.setFlows(this._flows.getSw());
        } else {
            this._flows = null;
            this._swSecurityScheme.setFlows(null);
        }
    }

    @Override
    public String getOpenIdConnectUrl() {
        return this._swSecurityScheme.getOpenIdConnectUrl();
    }

    @Override
    public void setOpenIdConnectUrl(String openIdConnectUrl) {
        this._swSecurityScheme.setOpenIdConnectUrl(openIdConnectUrl);
    }
}

